/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal;

import oracle.eclipse.tools.webservices.model.jws.JWSService;
import oracle.eclipse.tools.webservices.model.jws.ModelPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSServiceResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IBindings;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IService;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.AbstractBindingsModelResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.BindingsResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;

public class ServiceResource
extends AbstractBindingsModelResource<JWSService> {
    private ValuePropertyMapper<Value<String>> portName;
    private ValuePropertyMapper<Value<String>> className;
    private ValuePropertyMapper<Value<String>> javaDoc;
    private ValuePropertyMapper<Value<Boolean>> mimeContent;

    public ServiceResource(Resource resource, JWSService service) {
        super(resource, service);
    }

    public void init(Element element) {
        super.init(element);
        this.portName = new ValuePropertyMapper(JWSService.PROP_PORT_NAME, (Element)this.getBase(), IService.PROP_PORT_NAME, this.element());
        this.className = new ValuePropertyMapper(JWSService.PROP_CLASS_NAME, (Element)this.getBase(), IService.PROP_CLASS_NAME, this.element());
        this.javaDoc = new ValuePropertyMapper(JWSService.PROP_JAVA_DOC, (Element)this.getBase(), IService.PROP_CLASS_JAVADOC, this.element());
        this.mimeContent = new ValuePropertyMapper(JWSService.PROP_MIME_CONTENT_ENABLED, (Element)this.getBase(), IService.PROP_MIME_CONTENT_ENABLED, this.element());
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.className);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.mimeContent);
    }

    @Override
    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IService.PROP_PORT_NAME) {
            return this.createValuePropertyMapperBinding(this.portName);
        }
        if (p == IService.PROP_CLASS_NAME) {
            return this.createValuePropertyMapperBinding(this.className);
        }
        if (p == IService.PROP_CLASS_JAVADOC) {
            return this.createValuePropertyMapperBinding(this.javaDoc);
        }
        if (p == IService.PROP_MIME_CONTENT_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return ServiceResource.this.mimeContent.read();
                }

                public void write(String value) {
                    ServiceResource.this.setMimeContentEnabled(value);
                }
            };
        }
        if (p == IService.PROP_DISPLAY_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return ServiceResource.this.getDisplayName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IService.PROP_DISPLAY_NAME_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return ServiceResource.this.getDisplayNameTypeString();
                }

                public void write(String value) {
                    ServiceResource.this.setDisplayNameTypeString(value);
                }
            };
        }
        return null;
    }

    void setListenersEnabled(boolean enabled) {
        IBindings b = (IBindings)this.element().nearest(IBindings.class);
        if (b != null) {
            BindingsResource resource = (BindingsResource)b.resource();
            resource.setListenersEnabled(enabled);
        }
    }

    public void setMimeContentEnabled(Boolean enabled) {
        this.setListenersEnabled(false);
        this.mimeContent.setValue((Object)enabled);
        this.setListenersEnabled(true);
    }

    public void setMimeContentEnabled(String enabled) {
        this.setListenersEnabled(false);
        this.mimeContent.setValue((Object)enabled);
        this.setListenersEnabled(true);
    }

    public void removeBinding() {
        ((JWSServiceResource)((JWSService)this.getBase()).resource()).removePortBinding();
    }

    @Override
    protected ValueProperty getJavaNameValueProperty() {
        return IService.PROP_CLASS_NAME;
    }

    @Override
    protected ValueProperty getWSDLNameValueProperty() {
        return IService.PROP_PORT_NAME;
    }
}

