/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal;

import oracle.eclipse.tools.webservices.model.jws.JWSOperationParameter;
import oracle.eclipse.tools.webservices.model.jws.ModelPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IMethodParameter;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.AbstractBindingsModelResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;

public class MethodParameterResource
extends AbstractBindingsModelResource<JWSOperationParameter> {
    private ValuePropertyMapper<Value<String>> name;
    private ValuePropertyMapper<Value<String>> type;
    private ValuePropertyMapper<Value<Boolean>> in;
    private ValuePropertyMapper<Value<Boolean>> out;

    public MethodParameterResource(Resource resource, JWSOperationParameter parameter) {
        super(resource, parameter);
    }

    public void init(Element element) {
        super.init(element);
        this.name = new ValuePropertyMapper(JWSOperationParameter.PROP_NAME, (Element)this.getBase(), IMethodParameter.PROP_PARAMETER_NAME, this.element());
        this.type = new ValuePropertyMapper(JWSOperationParameter.PROP_TYPE, (Element)this.getBase(), IMethodParameter.PROP_PARAMETER_TYPE, this.element());
        this.in = new ValuePropertyMapper(JWSOperationParameter.PROP_IN, (Element)this.getBase(), IMethodParameter.PROP_IN, this.element());
        this.out = new ValuePropertyMapper(JWSOperationParameter.PROP_OUT, (Element)this.getBase(), IMethodParameter.PROP_OUT, this.element());
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.name);
    }

    @Override
    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IMethodParameter.PROP_PARAMETER_NAME) {
            return this.createValuePropertyMapperBinding(this.name);
        }
        if (p == IMethodParameter.PROP_PARAMETER_TYPE) {
            return this.createValuePropertyMapperBinding(this.type);
        }
        if (p == IMethodParameter.PROP_IN) {
            return this.createValuePropertyMapperBinding(this.in);
        }
        if (p == IMethodParameter.PROP_OUT) {
            return this.createValuePropertyMapperBinding(this.out);
        }
        if (p == IMethodParameter.PROP_DISPLAY_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return MethodParameterResource.this.getDisplayName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IMethodParameter.PROP_DISPLAY_NAME_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return MethodParameterResource.this.getDisplayNameTypeString();
                }

                public void write(String value) {
                    MethodParameterResource.this.setDisplayNameTypeString(value);
                }
            };
        }
        if (p == IMethodParameter.PROP_PARAMETER_DIRECTION) {
            return new ValuePropertyBinding(){

                public String read() {
                    return MethodParameterResource.this.getParameterDirection();
                }

                public void write(String value) {
                }
            };
        }
        return null;
    }

    public String getParameterName() {
        return this.name.read();
    }

    public String getParameterType() {
        return this.type.read();
    }

    public void setParameterName(String parameterName) {
        this.name.setValue((Object)parameterName);
    }

    public String getParameterDirection() {
        boolean out;
        boolean in = Boolean.parseBoolean(this.isIn());
        String direction = in & (out = Boolean.parseBoolean(this.isOut())) ? Messages.jaxws_custom_bindings_file_editor_method_parameter_input_output_label : (in ? Messages.jaxws_custom_bindings_file_editor_method_parameter_input_label : (out ? Messages.jaxws_custom_bindings_file_editor_method_parameter_output_label : Messages.jaxws_custom_bindings_file_editor_method_parameter_unknown_label));
        return direction;
    }

    public String isIn() {
        return this.in.read();
    }

    public String isOut() {
        return this.out.read();
    }
}

