/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.model.jws.JWSHandlerChain;
import oracle.eclipse.tools.webservices.model.jws.JWSJavaPackage;
import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSModelGroup;
import oracle.eclipse.tools.webservices.model.jws.LayeredListPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ModelPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.DisplayNameType;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IBindings;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IEndpointInterface;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IErrorNode;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IHandlerChain;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.AbstractBindingsModelResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.EndpointInterfaceResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.ErrorNodeResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.HandlerChainResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.localization.LocalizationService;

public class BindingsResource
extends AbstractBindingsModelResource<JWSModelGroup> {
    private final ResourceStore store;
    private ValuePropertyMapper<Value<String>> wsdlUri;
    private ValuePropertyMapper<Value<String>> packageName;
    private ValuePropertyMapper<Value<String>> packageJavadoc;
    private ValuePropertyMapper<Value<Boolean>> asyncMapping;
    private ValuePropertyMapper<Value<Boolean>> mimeContent;
    private ValuePropertyMapper<Value<Boolean>> wrapperStyle;
    private LayeredListPropertyMapper<JWSModel, IEndpointInterface> endpoints;
    private LayeredListPropertyMapper<JWSHandlerChain, IHandlerChain> handlerChains;
    private DisplayNameType displayNameType = DisplayNameType.JAVA;

    public BindingsResource(ResourceStore store, JWSModelGroup base) {
        super(null, base);
        this.store = store;
    }

    public void init(Element element) {
        super.init(element);
        this.wsdlUri = new ValuePropertyMapper(JWSModelGroup.PROP_WSDL_URI, (Element)this.getBase(), IBindings.PROP_WSDL_URI, element);
        this.packageName = new ValuePropertyMapper(JWSJavaPackage.PROP_NAME, ((JWSModelGroup)this.getBase()).getJavaPackage().content(true), IBindings.PROP_PACKAGE_NAME, element);
        this.packageJavadoc = new ValuePropertyMapper(JWSJavaPackage.PROP_JAVA_DOC, ((JWSModelGroup)this.getBase()).getJavaPackage().content(true), IBindings.PROP_PACKAGE_JAVADOC, element);
        this.asyncMapping = new ValuePropertyMapper(JWSModelGroup.PROP_ASYNC_ENABLED, (Element)this.getBase(), IBindings.PROP_ASYNC_MAPPING_ENABLED, element);
        this.mimeContent = new ValuePropertyMapper(JWSModelGroup.PROP_MIME_CONTENT_ENABLED, (Element)this.getBase(), IBindings.PROP_MIME_CONTENT_ENABLED, element);
        this.wrapperStyle = new ValuePropertyMapper(JWSModelGroup.PROP_WRAPPER_STYLE_ENABLED, (Element)this.getBase(), IBindings.PROP_WRAPPER_STYLE_ENABLED, element);
        this.endpoints = new LayeredListPropertyMapper(JWSModelGroup.PROP_JAVA_WEBSERVICES, (Element)this.getBase(), IBindings.PROP_ENDPOINT_INTERFACES, element, (LayeredListPropertyMapper.IListResourceFactory)new LayeredListPropertyMapper.IListResourceFactory<JWSModel, IEndpointInterface>(){

            public Resource createNewResource(ElementType type, JWSModel fromElement, ElementList<IEndpointInterface> parent) {
                return new EndpointInterfaceResource((Resource)BindingsResource.this, fromElement);
            }

            public ElementType type(Resource resource) {
                return IEndpointInterface.TYPE;
            }

            public void setUnderlyingElementForType(ElementType type, JWSModel fromElement) {
            }
        });
        this.handlerChains = new LayeredListPropertyMapper(JWSModelGroup.PROP_HANDLER_CHAINS, (Element)this.getBase(), IBindings.PROP_HANDLER_CHAINS, element, (LayeredListPropertyMapper.IListResourceFactory)new LayeredListPropertyMapper.IListResourceFactory<JWSHandlerChain, IHandlerChain>(){

            public Resource createNewResource(ElementType type, JWSHandlerChain fromElement, ElementList<IHandlerChain> parent) {
                return new HandlerChainResource((Resource)BindingsResource.this, fromElement);
            }

            public ElementType type(Resource resource) {
                return IHandlerChain.TYPE;
            }

            public void setUnderlyingElementForType(ElementType type, JWSHandlerChain fromElement) {
            }
        });
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.wsdlUri);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.packageName);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.packageJavadoc);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.asyncMapping);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.mimeContent);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.wrapperStyle);
    }

    @Override
    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IBindings.PROP_ENDPOINT_INTERFACES) {
            return this.endpoints;
        }
        if (p == IBindings.PROP_HANDLER_CHAINS) {
            return this.handlerChains;
        }
        if (p == IBindings.PROP_ERROR_NODES) {
            return this.getErrorNodes((Resource)this);
        }
        if (p == IBindings.PROP_ASYNC_MAPPING_ENABLED) {
            return this.createValuePropertyMapperBinding(this.asyncMapping);
        }
        if (p == IBindings.PROP_MIME_CONTENT_ENABLED) {
            return this.createValuePropertyMapperBinding(this.mimeContent);
        }
        if (p == IBindings.PROP_WSDL_URI) {
            return this.createValuePropertyMapperBinding(this.wsdlUri);
        }
        if (p == IBindings.PROP_WRAPPER_STYLE_ENABLED) {
            return this.createValuePropertyMapperBinding(this.wrapperStyle);
        }
        if (p == IBindings.PROP_PACKAGE_JAVADOC) {
            return this.createValuePropertyMapperBinding(this.packageJavadoc);
        }
        if (p == IBindings.PROP_PACKAGE_NAME) {
            return this.createValuePropertyMapperBinding(this.packageName);
        }
        if (p == IBindings.PROP_DISPLAY_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return BindingsResource.this.getDisplayName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IBindings.PROP_DISPLAY_NAME_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return BindingsResource.this.getDisplayNameType().toString();
                }

                public void write(String value) {
                    if (DisplayNameType.WSDL.toString().equalsIgnoreCase(value)) {
                        BindingsResource.this.setDisplayNameType(DisplayNameType.WSDL);
                    }
                    if (DisplayNameType.JAVA.toString().equalsIgnoreCase(value)) {
                        BindingsResource.this.setDisplayNameType(DisplayNameType.JAVA);
                    }
                }
            };
        }
        return null;
    }

    public String isAsyncMappingEnabled() {
        return this.asyncMapping.read();
    }

    public void setAsyncMappingEnabled(Boolean enabled) {
        this.asyncMapping.setValue((Object)enabled);
    }

    public void setAsyncMappingEnabled(String enabled) {
        this.asyncMapping.setValue((Object)enabled);
    }

    public String isMimeContentEnabled() {
        return this.mimeContent.read();
    }

    public void setMimeContentEnabled(Boolean enabled) {
        this.mimeContent.setValue((Object)enabled);
    }

    public void setMimeContentEnabled(String enabled) {
        this.mimeContent.setValue((Object)enabled);
    }

    public String isWrapperStyleEnabled() {
        return this.wrapperStyle.read();
    }

    public void setWrapperStyleEnabled(Boolean enabled) {
        this.wrapperStyle.setValue((Object)enabled);
    }

    public void setWrapperStyleEnabled(String enabled) {
        this.wrapperStyle.setValue((Object)enabled);
    }

    public String getPackageJavadoc() {
        return this.packageJavadoc.read();
    }

    public String getPackageName() {
        return this.packageName.read();
    }

    public void setPackageName(String packageName) {
        this.packageName.setValue((Object)packageName);
    }

    public void setPackageJavadoc(String packageJavadoc) {
        this.packageJavadoc.setValue((Object)packageJavadoc);
    }

    public String getWsdlUri() {
        return this.wsdlUri.read();
    }

    public void setWsdlUri(String wsdlUri) {
        this.wsdlUri.setValue((Object)wsdlUri);
    }

    void setListenersEnabled(boolean enabled) {
        this.endpoints.setRebroadcastEnabled(enabled);
        this.handlerChains.setRebroadcastEnabled(enabled);
    }

    @Override
    public void setDisplayNameType(DisplayNameType type) {
        this.displayNameType = type;
    }

    @Override
    public DisplayNameType getDisplayNameType() {
        return this.displayNameType;
    }

    public <A> A adapt(Class<A> adapterType) {
        Object adapter = this.store.adapt(adapterType);
        if (adapter == null) {
            adapter = super.adapt(adapterType);
        }
        return (A)adapter;
    }

    public boolean isOutOfDate() {
        return this.store.isOutOfDate();
    }

    public void save() throws ResourceStoreException {
        ((JWSModelGroup)this.getBase()).resource().save();
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        return this.store.getLocalizationService(locale);
    }

    public ListPropertyBinding getErrorNodes(final Resource resource) {
        ListPropertyBinding controller = new ListPropertyBinding(){
            private List<Resource> list = new ArrayList<Resource>();

            public List<Resource> read() {
                if (this.list.isEmpty() && ((IBindingsSet)((JWSModelGroup)BindingsResource.this.getBase()).getBindingsSet().content()).getInvalids().size() > 0) {
                    ErrorNodeResource errResource = new ErrorNodeResource(resource, (JWSModelGroup)BindingsResource.this.getBase());
                    this.list.add((Resource)errResource);
                }
                return this.list;
            }

            public Resource insert(ElementType type, int position) {
                Resource resource2 = this.insert(type);
                this.move(resource2, position);
                return resource2;
            }

            private Resource insert(ElementType type) {
                ErrorNodeResource errResource = new ErrorNodeResource(resource, (JWSModelGroup)BindingsResource.this.getBase());
                return errResource;
            }

            public ElementType type(Resource resource2) {
                return IErrorNode.TYPE;
            }
        };
        return controller;
    }
}

