/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal;

import java.util.HashMap;
import java.util.HashSet;
import oracle.eclipse.tools.webservices.model.BaseResource;
import oracle.eclipse.tools.webservices.model.jws.ModelPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.DisplayNameType;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IBindings;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IBindingsModel;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.DefaultValueService;

public abstract class AbstractBindingsModelResource<BASE_ELEMENT>
extends BaseResource<BASE_ELEMENT> {
    private HashMap<PropertyDef, ModelPropertyMapper<ValueProperty>> propertyMap = new HashMap();
    private HashSet<Element> fromModelSet = new HashSet();
    private static ShortCutCounts staticValidateSpecificProperty = new ShortCutCounts();
    private static ShortCutCounts staticValidateModels = new ShortCutCounts();
    private static ShortCutCounts staticValidateCounts = new ShortCutCounts();
    private ShortCutCounts validateSpecificProperty = new ShortCutCounts();
    private ShortCutCounts validateModels = new ShortCutCounts();
    private ShortCutCounts validateCounts = new ShortCutCounts();

    public AbstractBindingsModelResource(Resource resource, BASE_ELEMENT base) {
        super(resource, base);
    }

    protected PropertyBinding createBinding(Property property) {
        if (property == null) {
            return null;
        }
        ModelPropertyMapper<ValueProperty> mpm = this.propertyMap.get(property.definition());
        if (mpm instanceof ValuePropertyMapper) {
            return this.createValuePropertyMapperBinding((ValuePropertyMapper)mpm);
        }
        return null;
    }

    protected PropertyBinding createValuePropertyMapperBinding(final ValuePropertyMapper mapper) {
        return new ValuePropertyBinding(){

            public String read() {
                return mapper.read();
            }

            public void write(String value) {
                mapper.setValue((Object)value);
            }
        };
    }

    private static boolean doWeNeedToValidate(Element model, ShortCutCounts counts, ShortCutCounts staticCounts) {
        IDocument doc;
        ITextFileBuffer buffer;
        ++counts.totalCalls;
        ++staticCounts.totalCalls;
        IFile f = (IFile)model.resource().adapt(IFile.class);
        IPath p = f.getFullPath();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager != null && (buffer = manager.getTextFileBuffer(p, LocationKind.IFILE)) != null && (doc = buffer.getDocument()) != null) {
            long stamp = doc.get().hashCode();
            if (stamp == counts.lastValidate) {
                ++counts.shortCut;
                ++staticCounts.shortCut;
                return false;
            }
            counts.lastValidate = stamp;
        }
        return true;
    }

    public Status validate() {
        Status superStatus;
        if (!AbstractBindingsModelResource.doWeNeedToValidate(this.element(), this.validateCounts, staticValidateCounts)) {
            return this.validateCounts.lastValidateStatus;
        }
        Status status = Status.createOkStatus();
        Status mappedStatus = this.validateMappedModels();
        if (mappedStatus.severity().code() > status.severity().code()) {
            status = mappedStatus;
        }
        if (status.severity() != Status.Severity.ERROR && (superStatus = this.element().validation()).severity().code() > status.severity().code()) {
            status = superStatus;
        }
        this.validateCounts.lastValidateStatus = status;
        return status;
    }

    public void setDisplayNameType(DisplayNameType type) {
        IBindings parent = (IBindings)this.element().nearest(IBindings.class);
        parent.setDisplayNameType(type);
    }

    public void setDisplayNameTypeString(String type) {
        IBindings parent = (IBindings)this.element().nearest(IBindings.class);
        parent.setDisplayNameType(type);
    }

    public DisplayNameType getDisplayNameType() {
        IBindings parent = (IBindings)this.element().nearest(IBindings.class);
        return (DisplayNameType)((Object)parent.getDisplayNameType().content());
    }

    public String getDisplayNameTypeString() {
        IBindings parent = (IBindings)this.element().nearest(IBindings.class);
        if (parent != null) {
            return parent.getDisplayNameType().text();
        }
        return null;
    }

    public String getDisplayName() {
        ValueProperty valueProperty = this.getValuePropertyForType(this.getDisplayNameType());
        if (valueProperty != null) {
            Value value = this.element().property(valueProperty);
            return value.text();
        }
        return null;
    }

    public String getDefaultValue(ValueProperty property) {
        ModelPropertyMapper<ValueProperty> mapper = this.propertyMap.get(property);
        if (mapper != null) {
            ValueProperty modelProperty = (ValueProperty)mapper.getFromProperty();
            Element baseElement = mapper.getFromModel();
            return ((DefaultValueService)baseElement.property(modelProperty).service(DefaultValueService.class)).value();
        }
        return "";
    }

    public ValueProperty getValuePropertyForType(DisplayNameType type) {
        if (type == DisplayNameType.JAVA) {
            return this.getJavaNameValueProperty();
        }
        if (type == DisplayNameType.WSDL) {
            return this.getWSDLNameValueProperty();
        }
        return null;
    }

    public Status validateMappedModels() {
        if (!AbstractBindingsModelResource.doWeNeedToValidate(this.element(), this.validateModels, staticValidateModels)) {
            return this.validateModels.lastValidateStatus;
        }
        Status status = Status.createOkStatus();
        for (Element element : this.fromModelSet) {
            Status elementStatus = element.validation();
            if (elementStatus.severity().code() > status.severity().code()) {
                status = elementStatus;
            }
            if (status.severity() == Status.Severity.ERROR) break;
        }
        this.validateModels.lastValidateStatus = status;
        return status;
    }

    public Status validateMappedPropertyDef(ValueProperty toProperty) {
        if (!AbstractBindingsModelResource.doWeNeedToValidate(this.element(), this.validateSpecificProperty, staticValidateSpecificProperty)) {
            return this.validateSpecificProperty.lastValidateStatus;
        }
        if (!this.propertyMap.isEmpty()) {
            ModelPropertyMapper<ValueProperty> mapper = this.propertyMap.get(toProperty);
            ValueProperty fromProperty = (ValueProperty)mapper.getFromProperty();
            Element fromElement = mapper.getFromModel();
            this.validateSpecificProperty.lastValidateStatus = fromElement.property(fromProperty).validation();
        }
        return this.validateSpecificProperty.lastValidateStatus;
    }

    protected void registerMapper(ModelPropertyMapper<ValueProperty> mapper) {
        if (mapper.getToModel() == this.element()) {
            this.propertyMap.put(mapper.getToProperty(), mapper);
            this.fromModelSet.add(mapper.getFromModel());
        }
    }

    protected ValueProperty getJavaNameValueProperty() {
        return null;
    }

    protected ValueProperty getWSDLNameValueProperty() {
        return null;
    }

    protected ValueProperty getDisplayNameValueProperty() {
        ValueProperty property = (ValueProperty)this.element().type().property("DisplayName");
        return property;
    }

    protected static IBindingsModel getParentBindingsModel(Element element) {
        if (element instanceof IBindings) {
            return (IBindingsModel)element;
        }
        Element parentElement = null;
        if (element.parent() != null) {
            parentElement = element.parent().element();
        }
        if (parentElement == null) {
            return null;
        }
        if (parentElement instanceof IBindings) {
            return (IBindings)parentElement;
        }
        return AbstractBindingsModelResource.getParentBindingsModel(parentElement);
    }

    private static class ShortCutCounts {
        long lastValidate = 0L;
        long shortCut = 0L;
        long totalCalls = 0L;
        Status lastValidateStatus = null;

        private ShortCutCounts() {
        }

        public String toString() {
            return "(" + this.shortCut + '/' + this.totalCalls + ")";
        }
    }
}

