/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.assist;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IRemovableBinding;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.assist.AbstractQuickfixContributor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class CustomizationErrorQuickfixContributor
extends AbstractQuickfixContributor {
    @Override
    protected boolean canContribute(Status status) {
        return status.severity() == Status.Severity.ERROR && (status.message().contains("1001") || status.message().contains("1002"));
    }

    @Override
    protected List<PropertyEditorAssistContribution> getQuickFixContributions(Status status, final PropertyEditorAssistContext context) {
        ArrayList<PropertyEditorAssistContribution> contributions = new ArrayList<PropertyEditorAssistContribution>();
        if (status.message().contains("1002") && this.getNames(context).length > 0) {
            contributions.add(CustomizationErrorQuickfixContributor.createContribution(Messages.jaxws_custom_bindings_file_editor_fix_name_quick_fix_label, new Runnable(){

                @Override
                public void run() {
                    CustomizationErrorQuickfixContributor.this.fixName(context);
                }
            }));
        }
        if (status.message().contains("1001") || status.message().contains("1002")) {
            contributions.add(CustomizationErrorQuickfixContributor.createContribution(Messages.jaxws_custom_bindings_file_editor_remove_quick_fix_label, new Runnable(){

                @Override
                public void run() {
                    CustomizationErrorQuickfixContributor.this.remove(context);
                }
            }));
        }
        return contributions;
    }

    protected void fixName(PropertyEditorAssistContext context) {
        Object[] result;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(context.getShell(), (ILabelProvider)new LabelProvider());
        dialog.setElements((Object[])this.getNames(context));
        dialog.setMultipleSelection(false);
        dialog.setHelpAvailable(false);
        dialog.setTitle(Messages.jaxws_custom_bindings_file_editor_fix_name_dialog_title);
        dialog.setMessage(Messages.jaxws_custom_bindings_file_editor_fix_name_dialog_message);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            this.setName((String)result[0], context);
        }
    }

    protected String[] getNames(PropertyEditorAssistContext context) {
        return new String[0];
    }

    protected void setName(String name, PropertyEditorAssistContext context) {
    }

    protected void remove(PropertyEditorAssistContext context) {
        ((IRemovableBinding)context.getPart().getLocalModelElement()).removeBinding();
    }
}

