/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.actions;

import java.util.ArrayList;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.webservices.JAXVersion;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.JAXWSBindingsEditor;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IBindings;
import oracle.eclipse.tools.webservices.ui.wizards.WsdlModelFactory;
import oracle.eclipse.tools.webservices.ui.wizards.wsdlc.WsdlcWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Shell;

public class LaunchWSDLCAction
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        JAXWSBindingsEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        IFile bindingsFile = editor.getFile();
        IFile wsdlFile = EclipseFileUtil.computeReferencedFile((IFile)bindingsFile, (String)editor.getWsdlUri());
        if (!wsdlFile.exists()) {
            MessageDialog.openError((Shell)((SwtPresentation)context).shell(), (String)Messages.jaxws_custom_bindings_file_editor_non_existant_wsdl_error_title, (String)Messages.jaxws_custom_bindings_file_editor_non_existant_wsdl_error_message);
            return null;
        }
        IBindings bindings = (IBindings)editor.getModelElement();
        if (bindings.validation().severity() == Status.Severity.ERROR) {
            MessageDialog.openError((Shell)((SwtPresentation)context).shell(), (String)Messages.jaxws_custom_bindings_file_editor_launch_wsdlc_error_title, (String)Messages.jaxws_custom_bindings_file_editor_launch_wsdlc_error_message);
            return null;
        }
        LightweightWsdlModel model = WsdlModelFactory.createModel((IRunnableContext)new ProgressMonitorDialog(((SwtPresentation)context).shell()), wsdlFile);
        if (model != null) {
            ArrayList<IFile> bindingsFiles = new ArrayList<IFile>();
            bindingsFiles.add(bindingsFile);
            WsdlcWizard wizard = new WsdlcWizard(bindingsFiles);
            if (wizard.updateModel(model)) {
                WizardDialog dialog = new WizardDialog(((SwtPresentation)context).shell(), (IWizard)wizard);
                dialog.open();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        JAXWSBindingsEditor editor = this.getEditor();
        if (editor != null && editor.getFile() != null) {
            IProject project = editor.getFile().getProject();
            this.setEnabled(WebServiceProject.isWebServiceProject((IProject)project) && JAXVersion.JAX_WS.isOnProject(project));
        }
        return super.isEnabled();
    }

    private JAXWSBindingsEditor getEditor() {
        ISapphirePart part = this.getPart();
        JAXWSBindingsEditor editor = (JAXWSBindingsEditor)((Object)part.nearest(JAXWSBindingsEditor.class));
        return editor;
    }
}

