/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.decorators;

import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.ui.util.Images;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class WebServiceDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (this.isWebService(element)) {
            decoration.addOverlay(Images.DEC_WEB_SERVICE, 3);
        }
    }

    private boolean isWebService(Object obj) {
        if (!(obj instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)obj;
        ISchedulingRule rule = null;
        try {
            rule = ResourcesPlugin.getWorkspace().getRuleFactory().deleteRule((IResource)file);
            Job.getJobManager().beginRule(rule, null);
            boolean bl = WebServiceProject.isWebService((IFile)file);
            return bl;
        }
        finally {
            if (rule != null) {
                Job.getJobManager().endRule(rule);
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return "contentTypeId".equals(property);
    }
}

