/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.variables.context;

import java.util.HashMap;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceJavaVariable;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.BaseVariableContext;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.IVariableContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.templates.TemplateVariable;

public class MethodVariableContext
extends BaseVariableContext
implements IVariableContext {
    private HashMap<String, IMethod> identityMap;

    public MethodVariableContext(TemplateVariable variable) {
        super(variable);
        this.initialize();
    }

    @Override
    public void create() {
        this.identityMap = new HashMap();
    }

    @Override
    public String getValue() {
        if (this.variable instanceof WebServiceJavaVariable) {
            return ((WebServiceJavaVariable)this.variable).getCurrentValue();
        }
        return this.variable.getDefaultValue();
    }

    @Override
    public void initialize() {
        this.create();
        if (this.variable instanceof WebServiceJavaVariable) {
            ((WebServiceJavaVariable)this.variable).setVariableContext(this);
        }
    }

    @Override
    public boolean hasValues() {
        return !this.identityMap.isEmpty();
    }

    public String[] getKeySetArray() {
        Set<String> set = this.identityMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void add(String index, IMethod value) {
        this.identityMap.put(index, value);
    }

    public String getQualifiedReturnType() {
        IMethod method = this.identityMap.get(this.getValue());
        if (method != null) {
            try {
                return Signature.toString((String)method.getReturnType());
            }
            catch (IllegalArgumentException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
            }
        }
        return null;
    }

    public IMethod getMethod() {
        return this.identityMap.get(this.getValue());
    }
}

