/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.variables.context;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.context.WebServiceJavaContext;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceJavaVariable;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.BaseVariableContext;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.IVariableContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.templates.TemplateVariable;

public final class MemberVariableContext
extends BaseVariableContext
implements IVariableContext {
    private HashMap<String, IMember> identityMap;

    public MemberVariableContext(TemplateVariable variable) {
        super(variable);
        this.initialize();
    }

    @Override
    public void create() {
        this.identityMap = new HashMap();
    }

    @Override
    public String getValue() {
        if (this.variable instanceof WebServiceJavaVariable) {
            return ((WebServiceJavaVariable)this.variable).getCurrentValue();
        }
        return this.variable.getDefaultValue();
    }

    @Override
    public void initialize() {
        this.create();
        if (this.variable instanceof WebServiceJavaVariable) {
            ((WebServiceJavaVariable)this.variable).setVariableContext(this);
        }
    }

    @Override
    public boolean hasValues() {
        return !this.identityMap.isEmpty();
    }

    public void add(String index, IMember value) {
        this.identityMap.put(index, value);
    }

    public String[] getKeySetArray() {
        Set<String> set = this.identityMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public List<IMethod> findAnnotatedMethods(String qualifiedAnnotationType) throws JavaModelException {
        IMember serviceClass = this.identityMap.get(this.getValue());
        return WebServiceJavaContext.findAnnotatedMethods(qualifiedAnnotationType, serviceClass);
    }

    public String getFullyQualifiedParameterizedName() {
        IMember type = this.identityMap.get(this.getValue());
        if (type instanceof IType) {
            try {
                return ((IType)type).getFullyQualifiedParameterizedName();
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
            }
        }
        return null;
    }
}

