/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.common.util.ast.ElementNamingHelper;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.ast.AnnotationFactory;
import oracle.eclipse.tools.webservices.ui.completion.ast.FieldDeclarationBuilder;
import oracle.eclipse.tools.webservices.ui.completion.context.ASTInvocationContext;
import oracle.eclipse.tools.webservices.ui.completion.context.TemplateFormatter;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceVariableFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.dialogs.ListDialog;

public class WebServiceJavaContext
extends DocumentTemplateContext {
    private static final int ALL_SEARCH_SCOPE = 15;
    private final ASTInvocationContext astInvocationContext;
    private final Shell shell;
    private final IJavaProject project;

    public WebServiceJavaContext(TemplateContextType type, ASTInvocationContext astInvocationContext, Shell parent, IJavaProject project) {
        super(type, astInvocationContext.getDocument(), astInvocationContext.getStartingOffset(), astInvocationContext.getLength());
        this.astInvocationContext = astInvocationContext;
        this.shell = parent;
        this.project = project;
    }

    public Shell getShell() {
        return this.shell;
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(TemplateVariableType type, String name, int[] offsets) {
                TemplateVariable variable = WebServiceVariableFactory.WebServiceVariableType.getVariableType(type).createTemplateVariable(type, name, (TemplateContext)WebServiceJavaContext.this, offsets);
                return variable;
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        this.rewriteAST();
        if (!this.isReadOnly()) {
            TemplateFormatter formatter = new TemplateFormatter(this.getProject(), buffer, this.getDocument(), this.getStart());
            try {
                if (!formatter.format()) {
                    throw new TemplateException(Messages.template_formatter_error_message);
                }
            }
            catch (MalformedTreeException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
            catch (BadPositionCategoryException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
        }
        return buffer;
    }

    public String launchSelectionDialog(String[] choices) {
        if (this.isReadOnly()) {
            return choices[0];
        }
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setTitle(Messages.template_selection_dialog_title);
        dialog.setMessage(Messages.template_selection_dialog_message);
        dialog.setInput((Object)choices);
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return null;
            }
            return (String)result[0];
        }
        return null;
    }

    public void addImport(String type) {
        if (type == null || this.isReadOnly()) {
            return;
        }
        ICompilationUnit cu = this.astInvocationContext.getCompilationUnit();
        if (cu == null) {
            return;
        }
        try {
            CompilationUnit root;
            boolean qualified;
            boolean bl = qualified = type.indexOf(46) != -1;
            if (!qualified) {
                List<IMember> matches = this.javaTypeAllSearchScope(type);
                if (matches.size() != 1) {
                    return;
                }
                IMember member = matches.get(0);
                type = member.getDeclaringType().getFullyQualifiedName();
            }
            ImportRewrite importRewrite = (root = this.astInvocationContext.getASTRoot()) == null ? ImportRewrite.create((ICompilationUnit)cu, (boolean)true) : ImportRewrite.create((CompilationUnit)root, (boolean)true);
            importRewrite.addImport(type, importRewrite.getDefaultImportRewriteContext());
            TextEdit importEdit = null;
            try {
                importEdit = importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor());
                importEdit.apply(this.getDocument());
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
            }
            catch (MalformedTreeException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
            catch (BadLocationException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
            return;
        }
    }

    public void addImportAST(String type) {
        boolean qualified;
        if (type == null || this.isReadOnly()) {
            return;
        }
        ICompilationUnit icu = this.astInvocationContext.getCompilationUnit();
        if (icu == null) {
            return;
        }
        boolean bl = qualified = type.indexOf(46) != -1;
        if (!qualified) {
            List<IMember> matches = this.javaTypeAllSearchScope(type);
            if (matches.size() != 1) {
                return;
            }
            IMember member = matches.get(0);
            type = member.getDeclaringType().getFullyQualifiedName();
        }
        this.astInvocationContext.addImport(type);
    }

    public static List<IMethod> findAnnotatedMethods(String qualifiedAnnotationType, IMember serviceClass) throws JavaModelException {
        IType tp;
        ArrayList<IMethod> annotatedMethodList = new ArrayList<IMethod>();
        if (serviceClass == null) {
            return annotatedMethodList;
        }
        IClassFile cl = serviceClass.getClassFile();
        if (cl != null && (tp = cl.getType()) != null) {
            IMethod[] methods;
            IAnnotation[] annotations = null;
            IMethod[] iMethodArray = methods = tp.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                IAnnotation[] iAnnotationArray = annotations = method.getAnnotations();
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotation annotation = iAnnotationArray[n4];
                    if (annotation != null && annotation.getElementName().contains(qualifiedAnnotationType)) {
                        annotatedMethodList.add(method);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return annotatedMethodList;
    }

    public static IType findAnnotatedType(String qualifiedAnnotationType, IMember serviceClass) throws JavaModelException {
        IType tp;
        if (serviceClass == null) {
            return null;
        }
        IClassFile cl = serviceClass.getClassFile();
        if (cl != null && (tp = cl.getType()) != null) {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = tp.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation != null && annotation.getElementName().contains(qualifiedAnnotationType)) {
                    return tp;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Object findAnnotatedAttributeValue(String qualifiedAnnotationType, String key, IAnnotatable method) throws JavaModelException {
        IAnnotation[] annotations;
        if (method == null || key == null) {
            return null;
        }
        IAnnotation[] iAnnotationArray = annotations = method.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if (annotation != null && annotation.getElementName().contains(qualifiedAnnotationType)) {
                IMemberValuePair[] mvpArray;
                IMemberValuePair[] iMemberValuePairArray = mvpArray = annotation.getMemberValuePairs();
                int n3 = mvpArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair mvp = iMemberValuePairArray[n4];
                    if (key.equals(mvp.getMemberName())) {
                        return mvp.getValue();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public String createUniqueName(String baseName, boolean excludeAllTypeNames) {
        ICompilationUnit icu = this.astInvocationContext.getCompilationUnit();
        IType[] types = null;
        String uniqueName = null;
        try {
            types = icu.getTypes();
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
        }
        if (types != null && types.length > 0) {
            ElementNamingHelper elementNamingHelper = ElementNamingHelper.create((IType)types[0]);
            if (excludeAllTypeNames) {
                List<SimpleName> localTypes = this.findLocalTypeNames();
                ArrayList<String> excluded = new ArrayList<String>(types.length);
                for (SimpleName name : localTypes) {
                    excluded.add(name.getIdentifier());
                }
                uniqueName = elementNamingHelper.getFieldName(baseName, excluded);
            } else {
                uniqueName = elementNamingHelper.getFieldName(baseName);
            }
        }
        return uniqueName;
    }

    public HashMap<String, IMember> findLocalTypes(String clazzType) {
        final HashMap<String, IMember> localTypes = new HashMap<String, IMember>();
        ASTNode containingNode = this.astInvocationContext.findContainingNode();
        final int startingOffset = this.astInvocationContext.getStartingOffset();
        TypeDeclaration td = this.getPrimaryTypeDeclaration();
        List bodyDeclarations = td.bodyDeclarations();
        final List<IMember> members = this.javaTypeImplementorApplicationSearchScope(clazzType);
        int i = 0;
        while (i < bodyDeclarations.size()) {
            FieldDeclaration fd;
            Type type;
            if (bodyDeclarations.get(i) instanceof MethodDeclaration) {
                MethodDeclaration md = (MethodDeclaration)bodyDeclarations.get(i);
                if (this.astInvocationContext.doNodesIntersect((ASTNode)md, containingNode)) {
                    md.accept(new ASTVisitor(){

                        public boolean visit(VariableDeclarationStatement vd) {
                            Type type = vd.getType();
                            if (type.getStartPosition() < startingOffset && type instanceof SimpleType) {
                                String typeName = ((SimpleType)type).getName().getFullyQualifiedName();
                                for (IMember member : members) {
                                    if (!member.getElementName().equals(typeName)) continue;
                                    List fragments = vd.fragments();
                                    int i = 0;
                                    while (i < fragments.size()) {
                                        VariableDeclarationFragment vdf = (VariableDeclarationFragment)fragments.get(i);
                                        if (vdf.getStartPosition() < startingOffset) {
                                            localTypes.put(vdf.getName().getFullyQualifiedName(), member);
                                        }
                                        ++i;
                                    }
                                }
                            }
                            return false;
                        }

                        public boolean visit(SingleVariableDeclaration svd) {
                            Type type = svd.getType();
                            if (type.getStartPosition() < startingOffset && type instanceof SimpleType) {
                                String typeName = ((SimpleType)type).getName().getFullyQualifiedName();
                                for (IMember member : members) {
                                    if (!member.getElementName().equals(typeName)) continue;
                                    localTypes.put(svd.getName().getFullyQualifiedName(), member);
                                }
                            }
                            return false;
                        }
                    });
                }
            } else if (bodyDeclarations.get(i) instanceof FieldDeclaration && (type = (fd = (FieldDeclaration)bodyDeclarations.get(i)).getType()) instanceof SimpleType) {
                String typeName = ((SimpleType)type).getName().getFullyQualifiedName();
                for (IMember member : members) {
                    if (!member.getElementName().equals(typeName)) continue;
                    List fragments = fd.fragments();
                    int j = 0;
                    while (j < fragments.size()) {
                        VariableDeclarationFragment vdf = (VariableDeclarationFragment)fragments.get(j);
                        localTypes.put(vdf.getName().getFullyQualifiedName(), member);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return localTypes;
    }

    public List<SimpleName> findLocalTypeNames() {
        final ArrayList<SimpleName> localTypes = new ArrayList<SimpleName>();
        ASTNode containingNode = this.astInvocationContext.findContainingNode();
        final int startingOffset = this.astInvocationContext.getStartingOffset();
        TypeDeclaration td = this.getPrimaryTypeDeclaration();
        List bodyDeclarations = td.bodyDeclarations();
        int i = 0;
        while (i < bodyDeclarations.size()) {
            FieldDeclaration fd;
            Type type;
            if (bodyDeclarations.get(i) instanceof MethodDeclaration) {
                MethodDeclaration md = (MethodDeclaration)bodyDeclarations.get(i);
                if (this.astInvocationContext.doNodesIntersect((ASTNode)md, containingNode)) {
                    md.accept(new ASTVisitor(){

                        public boolean visit(VariableDeclarationStatement vd) {
                            Type type = vd.getType();
                            if (type.getStartPosition() < startingOffset && type instanceof SimpleType) {
                                List fragments = vd.fragments();
                                int i = 0;
                                while (i < fragments.size()) {
                                    VariableDeclarationFragment vdf = (VariableDeclarationFragment)fragments.get(i);
                                    if (vdf.getStartPosition() < startingOffset) {
                                        localTypes.add(vdf.getName());
                                    }
                                    ++i;
                                }
                            }
                            return false;
                        }

                        public boolean visit(SingleVariableDeclaration svd) {
                            Type type = svd.getType();
                            if (type.getStartPosition() < startingOffset && type instanceof SimpleType) {
                                localTypes.add(svd.getName());
                            }
                            return false;
                        }
                    });
                }
            } else if (bodyDeclarations.get(i) instanceof FieldDeclaration && (type = (fd = (FieldDeclaration)bodyDeclarations.get(i)).getType()) instanceof SimpleType) {
                List fragments = fd.fragments();
                int j = 0;
                while (j < fragments.size()) {
                    VariableDeclarationFragment vdf = (VariableDeclarationFragment)fragments.get(j);
                    localTypes.add(vdf.getName());
                    ++j;
                }
            }
            ++i;
        }
        return localTypes;
    }

    public List<IMethod> getPublicITypeMethods() throws JavaModelException {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        IMethod[] iMethodArray = this.getIType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (!method.isConstructor() && Flags.isPublic((int)method.getFlags())) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public String addFieldDeclarationAST(String qualifiedType, List<String> annotations) {
        if (this.isReadOnly()) {
            return null;
        }
        TypeDeclaration td = this.getPrimaryTypeDeclaration();
        String baseName = String.valueOf(qualifiedType.toLowerCase().substring(0, 1)) + qualifiedType.substring(1);
        String name = this.createUniqueName(baseName, false);
        FieldDeclarationBuilder fdBuilder = new FieldDeclarationBuilder(td, name, qualifiedType, 2);
        for (String annotationName : annotations) {
            fdBuilder.addAnnotation(AnnotationFactory.createAnnotation(td.getAST(), annotationName));
        }
        this.astInvocationContext.insertFieldDeclaration(fdBuilder.getFieldDeclaration());
        return name;
    }

    public List<IMember> javaTypeAllSearchScope(String type) {
        return this.javaSearchScope(type, 15, 0, 1, 10);
    }

    public List<IMember> javaTypeImplementorApplicationSearchScope(String type) {
        return this.javaSearchScope(type, 2, 0, 1, 10);
    }

    public List<IMember> javaTypeClassInterfaceApplicationSearchScope(String type) {
        return this.javaSearchScope(type, 2, 10, 0, 10);
    }

    protected void rewriteAST() {
        if (this.isReadOnly()) {
            return;
        }
        try {
            Position position = new Position(this.getCompletionOffset(), 0);
            IDocument document = this.getDocument();
            String category = "__template_position_field" + System.currentTimeMillis();
            DefaultPositionUpdater updater = new DefaultPositionUpdater(category);
            document.addPositionCategory(category);
            document.addPositionUpdater((IPositionUpdater)updater);
            document.addPosition(position);
            try {
                this.astInvocationContext.commitRewrite();
                this.setCompletionOffset(position.getOffset());
            }
            finally {
                document.removePosition(position);
                document.removePositionUpdater((IPositionUpdater)updater);
                document.removePositionCategory(category);
            }
        }
        catch (BadLocationException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
    }

    private List<IMember> javaSearchScope(String type, int searchScope, int searchFor, int limitTo, int matchRule) {
        final ArrayList<IMember> typesOfReferences = new ArrayList<IMember>();
        if (type == null) {
            return typesOfReferences;
        }
        ICompilationUnit cu = this.astInvocationContext.getCompilationUnit();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{cu.getJavaProject()}, (int)searchScope);
        SearchPattern pattern = SearchPattern.createPattern((String)type, (int)searchFor, (int)limitTo, (int)matchRule);
        SearchEngine engine = new SearchEngine();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (!(element instanceof IMember)) {
                    return;
                }
                typesOfReferences.add((IMember)element);
            }
        };
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
        return typesOfReferences;
    }

    private TypeDeclaration getPrimaryTypeDeclaration() {
        CompilationUnit root = this.astInvocationContext.getASTRoot();
        return ReaderUtil.getPrimaryType((CompilationUnit)root);
    }

    public IType getIType() {
        return this.astInvocationContext.getCompilationUnit().findPrimaryType();
    }
}

