/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.ast;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class FieldDeclarationBuilder {
    private final TypeDeclaration typeDeclaration;
    private final String qualifiedType;
    private final String name;
    private final int modifierType;
    private FieldDeclaration fieldDeclaration;

    public FieldDeclarationBuilder(TypeDeclaration typeDeclaration, String name, String qualifiedType, int modifierType) {
        this.typeDeclaration = typeDeclaration;
        this.name = name;
        this.modifierType = modifierType;
        this.qualifiedType = qualifiedType;
        this.buildFieldDeclaration();
    }

    private void buildFieldDeclaration() {
        AST ast = this.typeDeclaration.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        SimpleName simpleName = fragment.getAST().newSimpleName(this.name);
        fragment.setName(simpleName);
        SimpleType simpleType = fragment.getAST().newSimpleType(fragment.getAST().newName(this.qualifiedType));
        this.fieldDeclaration = ast.newFieldDeclaration(fragment);
        this.fieldDeclaration.setType((Type)simpleType);
        this.fieldDeclaration.modifiers().addAll(ast.newModifiers(this.modifierType));
    }

    public void addAnnotation(Annotation annotation) {
        List modifiers = this.fieldDeclaration.modifiers();
        ListIterator<Annotation> stream = modifiers.listIterator();
        while (stream.hasNext()) {
            if (!((IExtendedModifier)stream.next()).isModifier()) continue;
            stream.previous();
            stream.add(annotation);
            return;
        }
        modifiers.add(annotation);
    }

    public FieldDeclaration getFieldDeclaration() {
        return this.fieldDeclaration;
    }
}

