/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.ast;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.StringLiteral;

public class AnnotationBuilder {
    private final int TYPE;
    private final AST ast;
    private Annotation annotation;

    public AnnotationBuilder(AST ast, int type) {
        this.TYPE = type;
        this.ast = ast;
        this.createTypeSpecificAnnotation();
    }

    private void createTypeSpecificAnnotation() {
        switch (this.TYPE) {
            case 77: {
                this.annotation = this.ast.newNormalAnnotation();
                break;
            }
        }
    }

    public void setMemberValue(String memberName, Object value, int valueSubType) {
        if (value != null) {
            Expression memberExpr = this.getConstantExpression(value, valueSubType);
            MemberValuePair mvp = this.ast.newMemberValuePair();
            mvp.setName(this.ast.newSimpleName(memberName));
            mvp.setValue(memberExpr);
            ((NormalAnnotation)this.annotation).values().add(mvp);
        }
    }

    public void setTypeName(String qualifiedName) {
        if (this.annotation != null) {
            this.annotation.setTypeName(this.ast.newName(qualifiedName));
        }
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    private Expression getConstantExpression(Object value, int type) {
        NumberLiteral expr = null;
        switch (type) {
            case 45: {
                if (!(value instanceof String)) break;
                String svalue = (String)value;
                expr = this.ast.newStringLiteral();
                ((StringLiteral)expr).setLiteralValue(svalue);
                break;
            }
            case 34: {
                if (!(value instanceof Number)) break;
                expr = this.ast.newNumberLiteral(value.toString());
                break;
            }
        }
        return expr;
    }
}

