/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion;

import java.util.ArrayList;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.completion.ProposalInfoFormatter;
import oracle.eclipse.tools.webservices.ui.completion.proposal.DependentProposalPosition;
import oracle.eclipse.tools.webservices.ui.completion.proposal.VariableProposalProcessor;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceJavaVariable;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceVariableFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class WebServiceTemplateCompletionProposal
extends TemplateProposal {
    private final Template template;
    private final TemplateContext templateContext;
    private final IRegion region;
    private IRegion selectedRegion;
    private DefaultPositionUpdater updater;

    public WebServiceTemplateCompletionProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image);
        this.template = template;
        this.templateContext = context;
        this.region = region;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            TemplateBuffer templateBuffer;
            this.templateContext.setReadOnly(false);
            int oldReplaceOffset = this.getReplaceOffset();
            try {
                templateBuffer = this.templateContext.evaluate(this.template);
            }
            catch (TemplateException e1) {
                this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e1));
                this.selectedRegion = this.region;
                return;
            }
            int start = this.getReplaceOffset();
            int shift = start - oldReplaceOffset;
            int end = Math.max(this.getReplaceEndOffset(), offset + shift);
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedModeModel model = new LinkedModeModel();
            TemplateVariable[] variables = templateBuffer.getVariables();
            boolean hasPositions = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                if (!variable.isUnambiguous()) {
                    DependentProposalPosition first;
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    Position pos = new Position(offsets[0] + start, length);
                    this.ensurePositionCategoryInstalled(document, model);
                    if (variable instanceof WebServiceJavaVariable) {
                        VariableProposalProcessor processor = WebServiceVariableFactory.constructVariableProposalProcessor(variable, variables, pos);
                        first = new DependentProposalPosition(document, offsets[0] + start, length, processor, WebServiceVariableFactory.WebServiceVariableType.getVariableType(variable.getVariableType()).getSequence());
                        document.addPosition(this.getCategory(), pos);
                    } else {
                        String[] values = variable.getValues();
                        ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                        int j = 0;
                        while (j < values.length) {
                            document.addPosition(this.getCategory(), pos);
                            proposals[j] = new CompletionProposal(values[j], pos.offset, length, length);
                            ++j;
                        }
                        first = proposals.length > 1 ? new ProposalPosition(document, offsets[0] + start, length, WebServiceVariableFactory.WebServiceVariableType.getVariableType(variable.getVariableType()).getSequence(), proposals) : new LinkedPosition(document, offsets[0] + start, length, WebServiceVariableFactory.WebServiceVariableType.getVariableType(variable.getVariableType()).getSequence());
                    }
                    int j = 0;
                    while (j != offsets.length) {
                        if (j == 0) {
                            group.addPosition((LinkedPosition)first);
                        } else {
                            group.addPosition(new LinkedPosition(document, offsets[j] + start, length));
                        }
                        ++j;
                    }
                    model.addGroup(group);
                    hasPositions = true;
                }
                ++i;
            }
            if (hasPositions) {
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                ui.enter();
                this.selectedRegion = ui.getSelectedRegion();
            } else {
                this.ensurePositionCategoryRemoved(document);
                this.selectedRegion = new Region(this.getCaretOffset(templateBuffer) + start, 0);
            }
        }
        catch (BadLocationException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.ensurePositionCategoryRemoved(document);
            this.selectedRegion = this.region;
        }
        catch (BadPositionCategoryException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.selectedRegion = this.region;
        }
    }

    public String getAdditionalProposalInfo() {
        TemplateBuffer templateBuffer;
        try {
            this.templateContext.setReadOnly(true);
            try {
                templateBuffer = this.templateContext.evaluate(this.template);
            }
            catch (TemplateException templateException) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        String info = null;
        if (templateBuffer != null && templateBuffer.getString() != null && templateBuffer.getString().length() > 0) {
            info = templateBuffer.getString();
            StringBuilder builder = new StringBuilder();
            ProposalInfoFormatter.insertPageProlog(builder, 0);
            ProposalInfoFormatter.addLargeHeader(builder, this.template.getDescription());
            this.addTemplateDetailedDescription(builder, this.template);
            this.addTemplateCodeSample(builder, templateBuffer.getString());
            this.addTemplateVariableDefinitionList(builder, templateBuffer.getVariables());
            ProposalInfoFormatter.addPageEpilog(builder);
            info = builder.toString();
        }
        return info;
    }

    private boolean hasVariableName(TemplateVariable variable) {
        return variable.getDefaultValue() != null && variable.getDefaultValue().length() != 0;
    }

    private void addTemplateDetailedDescription(StringBuilder builder, Template template) {
        WebServiceTemplateType type = WebServiceTemplateType.getTemplateType(template.getName());
        if (type != null) {
            ProposalInfoFormatter.addLineBreak(builder);
            ProposalInfoFormatter.addSmallHeader(builder, Messages.template_proposal_detailed_description);
            ProposalInfoFormatter.addParagraph(builder, type.getDescription());
            ProposalInfoFormatter.addLineBreak(builder);
        }
    }

    private void addTemplateCodeSample(StringBuilder builder, String code) {
        ProposalInfoFormatter.addLineBreak(builder);
        ProposalInfoFormatter.addSmallHeader(builder, Messages.template_proposal_code);
        ProposalInfoFormatter.addLineBreak(builder);
        ProposalInfoFormatter.addCode(builder, code);
    }

    private void addTemplateVariableDefinitionList(StringBuilder builder, TemplateVariable[] variables) {
        ProposalInfoFormatter.addLineBreak(builder);
        ProposalInfoFormatter.addLineBreak(builder);
        ProposalInfoFormatter.addSmallHeader(builder, Messages.template_proposal_variable_details);
        ProposalInfoFormatter.startDefinitionList(builder);
        ArrayList<TemplateVariable> whiteSpaceVariables = new ArrayList<TemplateVariable>();
        TemplateVariable[] templateVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable variable = templateVariableArray[n2];
            WebServiceVariableFactory.WebServiceVariableType type = WebServiceVariableFactory.WebServiceVariableType.getVariableType(variable.getVariableType());
            if (this.hasVariableName(variable)) {
                ProposalInfoFormatter.addDefinition(builder, String.valueOf(variable.getDefaultValue()) + "::" + type.getName(), type.getDescription());
            } else {
                whiteSpaceVariables.add(variable);
            }
            ++n2;
        }
        for (TemplateVariable variable : whiteSpaceVariables) {
            WebServiceVariableFactory.WebServiceVariableType type = WebServiceVariableFactory.WebServiceVariableType.getVariableType(variable.getVariableType());
            ProposalInfoFormatter.addDefinition(builder, String.valueOf(Messages.template_implicit_variable) + "::" + type.getName(), type.getDescription());
        }
        ProposalInfoFormatter.endDefinitionList(builder);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.updater = new DefaultPositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.updater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    WebServiceTemplateCompletionProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater((IPositionUpdater)this.updater);
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + ((Object)((Object)this)).toString();
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)Messages.template_proposal_error_dialog_title, (String)e.getMessage());
    }

    public static enum WebServiceTemplateType {
        SERVICE_CLIENT_DEFAULT("ServiceClientDefault", Messages.template_proposal_service_client_default_detailed_description),
        SERVICE_CLIENT_URL_DECLARATION("ServiceClientUrlDeclaration", Messages.template_proposal_service_client_url_detailed_description),
        SERVICE_CLIENT_WEB_SERVICE_REF("ServiceClientWebServiceRef", Messages.template_proposal_service_client_ref_detailed_description),
        SERVICE_CLIENT_HANDLER_CHAIN("ServiceClientHandlerChain", Messages.template_proposal_service_client_handler_chain_default_detailed_description),
        SERVICE_CLIENT_REF_HANDLER_CHAIN("ServiceClientRefHandlerChain", Messages.template_proposal_service_client_ref_handler_chain_detailed_description);

        private String name;
        private String description;

        private WebServiceTemplateType(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public static WebServiceTemplateType getTemplateType(String name) {
            if (name != null) {
                WebServiceTemplateType[] webServiceTemplateTypeArray = WebServiceTemplateType.values();
                int n = webServiceTemplateTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebServiceTemplateType wsTemp = webServiceTemplateTypeArray[n2];
                    if (wsTemp.getName().equals(name)) {
                        return wsTemp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

