/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.eclipse.tools.webservices.policy.IPolicyQuery;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.ISecurityPolicies;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.ISecurityPolicy;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.SecurityPoliciesResource;
import oracle.eclipse.tools.webservices.ui.policy.WeblogicPolicyUtil;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.server.core.IRuntime;

public class PolicyCompatibilityValidator
extends ValidationService {
    protected Status compute() {
        ElementList list = (ElementList)this.context(ElementList.of(ISecurityPolicy.class));
        ISecurityPolicies policyModel = (ISecurityPolicies)list.element();
        if (list.size() == 0) {
            return Status.createOkStatus();
        }
        SecurityPoliciesResource res = (SecurityPoliciesResource)policyModel.resource();
        IRuntime wlsRt = res.getRuntime();
        IPolicyQuery pq = WeblogicPolicyUtil.createPolicyQuery(wlsRt, QueryType.SERVER);
        if (pq == null) {
            return Status.createOkStatus();
        }
        pq.setQueryType(QueryType.SERVER);
        ArrayList<String> policies = new ArrayList<String>();
        for (ISecurityPolicy p : list) {
            String name = (String)p.getUri().content();
            if (name == null) continue;
            policies.add((String)p.getUri().content());
        }
        if (policies.size() == 0) {
            return Status.createOkStatus();
        }
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        Collection errors = pq.validatePoliciesFromName(policies);
        if (errors != null && errors.size() > 0) {
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                factory.merge(Status.createErrorStatus((String)((String)iterator.next())));
            }
            return factory.create();
        }
        HashSet<String> noDuplicates = new HashSet<String>();
        for (String policy : policies) {
            boolean notDup;
            if (policy == null || policy.isEmpty() || (notDup = noDuplicates.add(policy))) continue;
            factory.merge(Status.createWarningStatus((String)Messages.bind((String)Messages.jws_properties_annotatotion_duplicate_policy, (Object)policy)));
        }
        return factory.create();
    }
}

