/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.policy.IOWSMWsPolicy;
import oracle.eclipse.tools.webservices.policy.IPolicyQuery;
import oracle.eclipse.tools.webservices.policy.PolicyType;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.WebServicesUIMessages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.JwsAnnotationResource;
import oracle.eclipse.tools.webservices.ui.policy.WeblogicPolicyUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;

public class SecurityPolicyUriValueProvider
extends PossibleValuesService {
    private static boolean showOnce = false;

    protected void fillPossibleValues(Set<String> values) {
        Element model = (Element)this.context(Element.class);
        JwsAnnotationResource res = (JwsAnnotationResource)model.resource();
        IRuntime wlsRt = res.getRuntime();
        final IPolicyQuery pq = WeblogicPolicyUtil.createPolicyQuery(wlsRt, QueryType.SERVER);
        if (pq == null) {
            if (showOnce) {
                return;
            }
            showOnce = true;
            Status sts = new Status(4, "oracle.eclipse.tools.webservices.ui", WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_0"));
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_1"), (String)WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_2"), (IStatus)sts);
            return;
        }
        pq.setQueryType(QueryType.SERVER);
        final ArrayList policies = new ArrayList();
        if (pq.isOWSMPoliciesCachedFor(PolicyType.SECURITY)) {
            policies.addAll(pq.getOWSMPoliciesForType(PolicyType.SECURITY));
        } else {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_3"), 100);
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            policies.addAll(pq.getOWSMPoliciesForType(PolicyType.SECURITY));
                        }
                    };
                    t.start();
                    while (t.isAlive()) {
                        monitor.worked(1);
                        Thread.sleep(200L);
                    }
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(false, false, op);
            }
            catch (InvocationTargetException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
            catch (InterruptedException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
        }
        for (IOWSMWsPolicy p : policies) {
            values.add(p.getName());
        }
    }
}

