/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.annotations.jws;

import java.util.HashMap;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IBindingType;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IHandlerChain;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IJwsAnnotation;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IOneway;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IPolicies;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IPolicy;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IRequestWrapper;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IResponseWrapper;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.ISOAPBinding;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.ISecurityPolicies;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.ISecurityPolicy;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IServiceMode;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebEndpoint;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebFault;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebMethod;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebParam;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebResult;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebService;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebServiceClient;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebServiceProvider;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebServiceRef;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IWebServiceRefs;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.BindingTypeResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.HandlerChainResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.OnewayResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.PoliciesResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.PolicyResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.RequestWrapperResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.ResponseWrapperResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.SOAPBindingResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.SecurityPoliciesResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.SecurityPolicyResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.ServiceModeResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebEndpointResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebFaultResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebMethodResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebParamResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebResultResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebServiceClientResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebServiceProviderResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebServiceRefResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebServiceRefsResource;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal.WebServiceResource;
import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IAnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.PolicyAnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import org.eclipse.sapphire.Resource;

public class AnnotationFactory {
    private static HashMap<AnnotationElement, IJwsAnnotation> annotationMap = new HashMap();

    public static IJwsAnnotation getAnnotation(AnnotationElement annotationElement) {
        IJwsAnnotation annotation = annotationMap.get(annotationElement);
        if (annotation == null) {
            IAnnotationType iType = annotationElement.getAnnotationType();
            if (iType instanceof AnnotationType) {
                AnnotationType annotationType = (AnnotationType)iType;
                switch (annotationType) {
                    case WebService: {
                        annotation = (IJwsAnnotation)IWebService.TYPE.instantiate((Resource)new WebServiceResource(null, annotationElement));
                        break;
                    }
                    case WebMethod: {
                        annotation = (IJwsAnnotation)IWebMethod.TYPE.instantiate((Resource)new WebMethodResource(null, annotationElement));
                        break;
                    }
                    case SOAPBinding: {
                        annotation = (IJwsAnnotation)ISOAPBinding.TYPE.instantiate((Resource)new SOAPBindingResource(null, annotationElement));
                        break;
                    }
                    case OneWay: {
                        annotation = (IJwsAnnotation)IOneway.TYPE.instantiate((Resource)new OnewayResource(null, annotationElement));
                        break;
                    }
                    case WebParam: {
                        annotation = (IJwsAnnotation)IWebParam.TYPE.instantiate((Resource)new WebParamResource(null, annotationElement));
                        break;
                    }
                    case WebResult: {
                        annotation = (IJwsAnnotation)IWebResult.TYPE.instantiate((Resource)new WebResultResource(null, annotationElement));
                        break;
                    }
                    case WebFault: {
                        annotation = (IJwsAnnotation)IWebFault.TYPE.instantiate((Resource)new WebFaultResource(null, annotationElement));
                        break;
                    }
                    case RequestWrapper: {
                        annotation = (IJwsAnnotation)IRequestWrapper.TYPE.instantiate((Resource)new RequestWrapperResource(null, annotationElement));
                        break;
                    }
                    case ResponseWrapper: {
                        annotation = (IJwsAnnotation)IResponseWrapper.TYPE.instantiate((Resource)new ResponseWrapperResource(null, annotationElement));
                        break;
                    }
                    case WebEndpoint: {
                        annotation = (IJwsAnnotation)IWebEndpoint.TYPE.instantiate((Resource)new WebEndpointResource(null, annotationElement));
                        break;
                    }
                    case HandlerChain: {
                        annotation = (IJwsAnnotation)IHandlerChain.TYPE.instantiate((Resource)new HandlerChainResource(null, annotationElement));
                        break;
                    }
                    case ServiceMode: {
                        annotation = (IJwsAnnotation)IServiceMode.TYPE.instantiate((Resource)new ServiceModeResource(null, annotationElement));
                        break;
                    }
                    case WebServiceClient: {
                        annotation = (IJwsAnnotation)IWebServiceClient.TYPE.instantiate((Resource)new WebServiceClientResource(null, annotationElement));
                        break;
                    }
                    case WebServiceProvider: {
                        annotation = (IJwsAnnotation)IWebServiceProvider.TYPE.instantiate((Resource)new WebServiceProviderResource(null, annotationElement));
                        break;
                    }
                    case BindingType: {
                        annotation = (IJwsAnnotation)IBindingType.TYPE.instantiate((Resource)new BindingTypeResource(null, annotationElement));
                        break;
                    }
                    case WebServiceRefs: {
                        annotation = (IJwsAnnotation)IWebServiceRefs.TYPE.instantiate((Resource)new WebServiceRefsResource(null, annotationElement));
                        break;
                    }
                    case WebServiceRef: {
                        annotation = (IJwsAnnotation)IWebServiceRef.TYPE.instantiate((Resource)new WebServiceRefResource(null, annotationElement));
                    }
                }
            } else if (iType instanceof PolicyAnnotationType) {
                PolicyAnnotationType policyAnnotationType = (PolicyAnnotationType)iType;
                switch (policyAnnotationType) {
                    case Policies: {
                        annotation = (IJwsAnnotation)IPolicies.TYPE.instantiate((Resource)new PoliciesResource(null, annotationElement));
                        break;
                    }
                    case Policy: {
                        annotation = (IJwsAnnotation)IPolicy.TYPE.instantiate((Resource)new PolicyResource(null, annotationElement));
                        break;
                    }
                    case SecurityPolicies: {
                        annotation = (IJwsAnnotation)ISecurityPolicies.TYPE.instantiate((Resource)new SecurityPoliciesResource(null, annotationElement));
                        break;
                    }
                    case SecurityPolicy: {
                        annotation = (IJwsAnnotation)ISecurityPolicy.TYPE.instantiate((Resource)new SecurityPolicyResource(null, annotationElement));
                    }
                }
            }
            annotationMap.put(annotationElement, annotation);
        }
        return annotation;
    }
}

