/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.actions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.JAXVersion;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import oracle.eclipse.tools.webservices.model.bindings.IBindingsSet;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.actions.AntBasedWsdlAction;
import oracle.eclipse.tools.webservices.ui.wizards.WsdlModelFactory;
import oracle.eclipse.tools.webservices.ui.wizards.wsdlc.WsdlcWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public final class BindingsWsdlcAction
extends AntBasedWsdlAction {
    @Override
    protected WsdlcWizard createWizard() {
        return new WsdlcWizard(Collections.singletonList(this.getFile()));
    }

    @Override
    protected LightweightWsdlModel createModel() {
        XmlResourceStore xmlStore;
        IFile bindingsFile = this.getFile();
        try {
            xmlStore = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(bindingsFile));
        }
        catch (ResourceStoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            return null;
        }
        IBindingsSet bindingsModel = (IBindingsSet)IBindingsSet.TYPE.instantiate((Resource)new RootXmlResource(xmlStore));
        String uriString = bindingsModel.getWsdlUri().text();
        IFile f = null;
        if (uriString == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        if (uri == null || uri.getScheme() == null) {
            f = EclipseFileUtil.computeReferencedFile((IFile)bindingsFile, (String)uriString);
        }
        return WsdlModelFactory.createModel((IRunnableContext)new ProgressMonitorDialog(this.getShell()), f);
    }

    @Override
    protected boolean isFeatureEnabledOnProject(IProject project) {
        return WebServiceProject.isWebServiceProject((IProject)project) && JAXVersion.JAX_WS.isOnProject(project);
    }

    @Override
    protected boolean shouldEnable() {
        if (this.getSelection().size() != 1) {
            return false;
        }
        IFile file = this.getFile();
        if (file == null) {
            return false;
        }
        if (!EclipseFileUtil.isContentType((IFile)file, (String)"oracle.eclipse.tools.webservices.jaxWSBindings")) {
            return false;
        }
        return this.isFeatureEnabledOnProject(file.getProject());
    }
}

