/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.actions;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.JAXVersion;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.actions.WebServiceDerivedAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public abstract class AbstractJavaAction
extends WebServiceDerivedAction {
    @Override
    protected boolean isFeatureEnabledOnProject(IProject project) {
        return WebServiceProject.isWebServiceProject((IProject)project) && JAXVersion.JAX_WS.isOnProject(project);
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean enableAction = false;
        ICompilationUnit cu = this.getIcu();
        if (cu != null) {
            try {
                IType[] types = cu.getAllTypes();
                if (types != null && types.length > 0) {
                    enableAction = types[0].isClass();
                }
            }
            catch (JavaModelException jme) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)jme);
            }
        }
        action.setEnabled(enableAction);
    }

    protected ICompilationUnit getIcu() {
        IAdaptable a;
        IFile file;
        IJavaElement elem;
        Object obj;
        if (this.getSelection() != null && (obj = this.getSelection().getFirstElement()) instanceof IAdaptable && (elem = JavaCore.create((IFile)(file = (IFile)(a = (IAdaptable)obj).getAdapter(IFile.class)))) instanceof ICompilationUnit) {
            return (ICompilationUnit)elem;
        }
        return null;
    }
}

