/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.util;

import java.io.FileNotFoundException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class JAXRSUtil {
    public static final String VALUE = "value";
    public static final String JAXRS_PATH_CONTENT_TYPE_ID = "oracle.eclipse.tools.jaxrs.pathResource";
    public static final String MARKER_ID = "oracle.eclipse.tools.jaxrs.jaxrsProblem";

    public static boolean hasJaxrsFacetInstalled(IProject project) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.jaxrs");
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.jaxrs", (CoreException)e);
            return false;
        }
    }

    public static boolean isJaxrsResource(ICompilationUnit unit, boolean acceptInterfaces) {
        block4: {
            IType[] itypes;
            block5: {
                if (unit == null) {
                    return false;
                }
                boolean wsContent = JAXRSUtil.isJaxrsResource((IFile)unit.getCorrespondingResource());
                if (!wsContent) break block4;
                itypes = unit.getTypes();
                if (itypes != null && itypes.length != 0) break block5;
                return false;
            }
            try {
                return acceptInterfaces || !itypes[0].isInterface();
            }
            catch (JavaModelException e) {
                LoggingService.logDebug((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
            }
        }
        return false;
    }

    public static boolean isJaxrsResource(IFile file) {
        block4: {
            if (file == null || !file.exists()) {
                return false;
            }
            try {
                IContentType contentType;
                IContentDescription contentDesc = file.getContentDescription();
                if (contentDesc != null && (contentType = contentDesc.getContentType()) != null) {
                    return contentType.getId().equals(JAXRS_PATH_CONTENT_TYPE_ID);
                }
            }
            catch (CoreException e) {
                if (e.getStatus().getClass().equals(FileNotFoundException.class)) break block4;
                LoggingService.logDebug((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
            }
        }
        return false;
    }
}

