/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.util;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jdt.apt.core.internal.util.DeclarationsUtil;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;

public class JAXRSDeclarationsUtil {
    public static AnnotationValue getAnnotationValue(Declaration declaration, String annotationName, HashSet<String> typeNames) {
        MethodDeclaration methodDecl;
        TypeDeclaration declaringType;
        Collection mirrors = declaration.getAnnotationMirrors();
        boolean isMethodDecl = declaration instanceof MethodDeclaration;
        boolean methodHasJaxRSAnnotation = false;
        for (AnnotationMirror mirror : mirrors) {
            String typeName;
            AnnotationType type = mirror.getAnnotationType();
            AnnotationTypeDeclaration annTypeDecl = type.getDeclaration();
            if (annTypeDecl != null && (typeName = annTypeDecl.getQualifiedName()).equals(annotationName)) {
                return AnnotationUtils.getAnnotationValue((AnnotationMirror)mirror, (String)"value");
            }
            if (!isMethodDecl || !JAXRSDeclarationsUtil.isJaxRSMethodAnnotation(annotationName)) continue;
            methodHasJaxRSAnnotation = true;
        }
        if (methodHasJaxRSAnnotation) {
            return null;
        }
        if (declaration instanceof MethodDeclaration && (declaringType = (methodDecl = (MethodDeclaration)declaration).getDeclaringType()) instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = declaringType;
            if (typeNames.contains(typeDecl.getQualifiedName())) {
                return null;
            }
            typeNames.add(typeDecl.getQualifiedName());
            DeclarationsUtil declarationsUtil = new DeclarationsUtil();
            Collection methods = null;
            if (typeDecl instanceof ClassDeclaration) {
                ClassType classType = ((ClassDeclaration)typeDecl).getSuperclass();
                ClassDeclaration decl = classType.getDeclaration();
                methods = decl.getMethods();
            } else if (typeDecl instanceof InterfaceDeclaration) {
                methods = ((InterfaceDeclaration)typeDecl).getMethods();
            }
            if (methods != null) {
                for (MethodDeclaration md : methods) {
                    AnnotationValue annotationValue;
                    if (!declarationsUtil.overrides(methodDecl, md) || (annotationValue = JAXRSDeclarationsUtil.getAnnotationValue((Declaration)md, annotationName, typeNames)) == null) continue;
                    return annotationValue;
                }
            }
            for (InterfaceType interfaceType : typeDecl.getSuperinterfaces()) {
                InterfaceDeclaration interfaceDecl = interfaceType.getDeclaration();
                for (MethodDeclaration md : interfaceDecl.getMethods()) {
                    AnnotationValue annotationValue;
                    if (!declarationsUtil.overrides(methodDecl, md) || (annotationValue = JAXRSDeclarationsUtil.getAnnotationValue((Declaration)md, annotationName, typeNames)) == null) continue;
                    return annotationValue;
                }
            }
        }
        return null;
    }

    public static boolean isJaxRSMethodAnnotation(String annotationName) {
        return annotationName.equals("javax.ws.rs.Consumes") || annotationName.equals("javax.ws.rs.Produces") || annotationName.equals("javax.ws.rs.GET") || annotationName.equals("javax.ws.rs.POST") || annotationName.equals("javax.ws.rs.PUT") || annotationName.equals("javax.ws.rs.DELETE") || annotationName.equals("javax.ws.rs.HEAD") || annotationName.equals("javax.ws.rs.Path") || annotationName.equals("javax.ws.rs.PathParam") || annotationName.equals("javax.ws.rs.QueryParam") || annotationName.equals("javax.ws.rs.FormParam") || annotationName.equals("javax.ws.rs.MatrixParam") || annotationName.equals("javax.ws.rs.CookieParam") || annotationName.equals("javax.ws.rs.HeaderParam") || annotationName.equals("javax.ws.rs.Encoded") || annotationName.equals("javax.ws.rs.DefaultValue") || annotationName.equals("javax.ws.rs.Context");
    }

    public static boolean isResourceMethodParamAnnotation(String annotationName) {
        return annotationName.equals("javax.ws.rs.MatrixParam") || annotationName.equals("javax.ws.rs.QueryParam") || annotationName.equals("javax.ws.rs.PathParam") || annotationName.equals("javax.ws.rs.CookieParam") || annotationName.equals("javax.ws.rs.HeaderParam") || annotationName.equals("javax.ws.rs.Context") || annotationName.equals("javax.ws.rs.DefaultValue") || annotationName.equals("javax.ws.rs.Encoded");
    }
}

