/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.server;

import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.Activator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class PingServer {
    private static final int PING_DELAY = 500;
    private static final int PING_INTERVAL = 250;
    private int maxPings;
    private boolean stop = false;
    private URL url;
    private int startTimeout;
    private IStatus status = Status.CANCEL_STATUS;

    public PingServer(URL url, int startTimeout) {
        this.url = url;
        this.startTimeout = startTimeout;
        this.maxPings = this.guessMaxPings();
        this.ping();
    }

    private int guessMaxPings() {
        int startTimeout = this.getStartTimeout() * 1000;
        if (startTimeout > 0) {
            return startTimeout / 250;
        }
        return -1;
    }

    private int getStartTimeout() {
        return this.startTimeout;
    }

    protected void ping() {
        int count = 0;
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {}
        while (!this.stop) {
            try {
                if (count == this.maxPings) {
                    try {
                        this.status = Status.CANCEL_STATUS;
                    }
                    catch (Exception e) {
                        LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                    this.stop = true;
                    break;
                }
                ++count;
                URLConnection conn = this.url.openConnection();
                ((HttpURLConnection)conn).getResponseCode();
                if (!this.stop) {
                    Thread.sleep(200L);
                    this.status = Status.OK_STATUS;
                }
                this.stop = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
                this.status = Status.OK_STATUS;
                this.stop = true;
            }
            catch (Exception exception) {
                if (this.stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stop() {
        this.stop = true;
    }

    public IStatus getStatus() {
        return this.status;
    }
}

