/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.launcher.model.internal;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.jaxrs.jdt.MethodElement;
import oracle.eclipse.tools.jaxrs.jdt.TypeElement;
import oracle.eclipse.tools.jaxrs.launcher.model.IJaxrsMethod;
import oracle.eclipse.tools.jaxrs.launcher.model.IJaxrsModel;
import oracle.eclipse.tools.jaxrs.launcher.model.internal.JaxrsMethodResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;

public class JaxrsModelResource
extends Resource {
    private TypeElement typeElement;

    public JaxrsModelResource() {
        super(null);
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        Object binding = null;
        if (p == IJaxrsModel.PROP_METHODS) {
            binding = this.createMethodList();
        } else if (p == IJaxrsModel.PROP_REQUEST_URL) {
            binding = new ValuePropertyBinding(){
                private String value;

                public String read() {
                    return this.value;
                }

                public void write(String value) {
                    this.value = value;
                }
            };
        } else if (p instanceof ValueProperty) {
            binding = new ValuePropertyBinding(){
                private String value;

                public String read() {
                    return this.value;
                }

                public void write(String value) {
                    this.value = value;
                }
            };
        }
        return binding;
    }

    private ListPropertyBinding createMethodList() {
        LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

            protected List<?> readUnderlyingList() {
                TypeElement typeElement = JaxrsModelResource.this.getTypeElement();
                if (typeElement != null) {
                    return typeElement.findGetMethods();
                }
                return Collections.emptyList();
            }

            protected Resource resource(Object obj) {
                return new JaxrsMethodResource(JaxrsModelResource.this, (MethodElement)obj);
            }

            public ElementType type(Resource obj) {
                return IJaxrsMethod.TYPE;
            }
        };
        return listBinding;
    }

    void setTypeElement(TypeElement typeElement) {
        this.typeElement = typeElement;
    }

    TypeElement getTypeElement() {
        return this.typeElement;
    }
}

