/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.launcher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.Activator;
import oracle.eclipse.tools.jaxrs.JaxrsClassloaderAdapterFactory;
import oracle.eclipse.tools.jaxrs.jdt.ProjectPathUtil;
import oracle.eclipse.tools.jaxrs.server.Messages;
import oracle.eclipse.tools.jaxrs.server.PingServer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.SocketUtil;

public class JaxrsApplicationLaunchDelegate
extends JavaLaunchDelegate
implements IDebugEventSetListener {
    private static Map<ILaunch, File> fgLaunchToFileMap = new HashMap<ILaunch, File>();
    private boolean openBrowser = true;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"{0}...", (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.subTask("Verifying launch attributes...");
            this.verifyJaxrsApplicationAvailable(configuration);
            String mainTypeName = this.verifyMainTypeName(configuration);
            IVMRunner runner = this.getVMRunner(configuration, mode);
            File workingDir = this.verifyWorkingDirectory(configuration);
            String workingDirName = null;
            if (workingDir != null) {
                workingDirName = workingDir.getAbsolutePath();
            }
            URL rootUrl = this.getRootURL(configuration);
            String[] envp = this.getEnvironment(configuration);
            String pgmArgs = String.valueOf(rootUrl.toExternalForm()) + " " + this.getResourceClass(configuration);
            String vmArgs = this.getVMArguments(configuration);
            ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
            Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
            String[] classpath = this.getClasspath(configuration);
            VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
            runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
            runConfig.setEnvironment(envp);
            runConfig.setVMArguments(execArgs.getVMArgumentsArray());
            runConfig.setWorkingDirectory(workingDirName);
            runConfig.setVMSpecificAttributesMap(vmAttributesMap);
            runConfig.setBootClassPath(this.getBootpath(configuration));
            if (monitor.isCanceled()) {
                return;
            }
            this.prepareStopInMain(configuration);
            monitor.worked(1);
            monitor.subTask("Creating source locator...");
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            String port = "8080";
            try {
                port = configuration.getAttribute("oracle.eclipse.tools.jaxrs.SERVER_PORT", "8080");
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.jaxrs", (CoreException)e);
            }
            this.setOpenBrowser(true);
            if (SocketUtil.isPortInUse((int)Integer.parseInt(port), (int)5)) {
                this.alreadyInUseDialog(port);
            } else {
                runner.run(runConfig, launch, monitor);
            }
            PingServer server = new PingServer(this.getLaunchURL(configuration), 2);
            if (this.isOpenBrowser() && server.getStatus().isOK()) {
                HttpLaunchable http = new HttpLaunchable(this.getLaunchURL(configuration));
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                    browser.openURL(http.getURL());
                }
                catch (Exception exception) {}
            }
            if (monitor.isCanceled()) {
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object eventSource = event.getSource();
            switch (event.getKind()) {
                case 8: {
                    if (eventSource == null) break;
                    ILaunch launch = null;
                    if (eventSource instanceof IProcess) {
                        IProcess process = (IProcess)eventSource;
                        launch = process.getLaunch();
                    } else if (eventSource instanceof IDebugTarget) {
                        IDebugTarget debugTarget = (IDebugTarget)eventSource;
                        launch = debugTarget.getLaunch();
                    }
                    if (launch == null) break;
                    this.cleanup(launch);
                }
            }
            ++i;
        }
    }

    private void cleanup(ILaunch launch) {
        File temp = fgLaunchToFileMap.get(launch);
        if (temp != null) {
            try {
                fgLaunchToFileMap.remove(launch);
                temp.delete();
            }
            finally {
                if (fgLaunchToFileMap.isEmpty()) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
        }
    }

    protected static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block7: {
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = JaxrsApplicationLaunchDelegate.getInputStreamAsByteArray(stream, (int)file.length());
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    protected static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int bytesRead = -1;
            do {
                int available;
                if (contentsLength + (available = stream.available()) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + available];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((bytesRead = stream.read(contents, contentsLength, available)) <= 0) continue;
                contentsLength += bytesRead;
            } while (bytesRead > 0);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("oracle.eclipse.tools.jaxrs.JAXRS_SERVER_CLASS", "oracle.eclipse.tools.jaxrs.vbundle.server.JerseyHttpStarter");
    }

    protected File getDefaultWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String outputDir = JavaRuntime.getProjectOutputDirectory((ILaunchConfiguration)configuration);
        if (outputDir == null) {
            return new File(System.getProperty("user.dir"));
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(outputDir);
        if (resource == null || !resource.exists()) {
            return new File(System.getProperty("user.dir"));
        }
        return resource.getLocation().toFile();
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] superStrings = super.getClasspath(configuration);
        JaxrsClassloaderAdapterFactory factory = new JaxrsClassloaderAdapterFactory();
        URL[] urls = factory.getClasspathURLs(this.getJavaProject(configuration).getProject());
        ArrayList<String> classString = new ArrayList<String>();
        int i = 0;
        while (i < urls.length) {
            try {
                String s = new File(urls[i].toURI()).getCanonicalPath();
                classString.add(s);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < superStrings.length) {
            classString.add(superStrings[i]);
            ++i;
        }
        return classString.toArray(new String[classString.size()]);
    }

    public URL getRootURL(ILaunchConfiguration configuration) {
        try {
            return new URL(this.getRootUrl(configuration));
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            return null;
        }
    }

    public URL getLaunchURL(ILaunchConfiguration configuration) {
        try {
            StringBuilder sBuilder = new StringBuilder(this.getRootUrl(configuration));
            if (this.getEnableWadl(configuration)) {
                sBuilder.append("/application.wadl");
            } else {
                String requestUrl = this.getRequestUrl(configuration);
                if (!requestUrl.startsWith("/")) {
                    sBuilder.append("/");
                }
                sBuilder.append(requestUrl);
            }
            return new URL(sBuilder.toString());
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            return null;
        }
    }

    private String getRootUrl(ILaunchConfiguration configuration) throws CoreException {
        String base = "http://" + this.getHostName(configuration);
        int port = this.getPort(configuration);
        StringBuilder sBuilder = new StringBuilder(base);
        if (port == 80) {
            sBuilder.append("/" + this.getContextRoot(configuration));
        } else {
            sBuilder.append(":" + port + "/" + this.getContextRoot(configuration));
        }
        return sBuilder.toString();
    }

    public String getHostName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("oracle.eclipse.tools.jaxrs.HOST_NAME", "localhost");
    }

    public int getPort(ILaunchConfiguration configuration) throws CoreException {
        return Integer.parseInt(configuration.getAttribute("oracle.eclipse.tools.jaxrs.SERVER_PORT", "8080"));
    }

    public String getContextRoot(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("oracle.eclipse.tools.jaxrs.CONTEXT_ROOT", "resources");
    }

    public boolean getEnableWadl(ILaunchConfiguration configuration) throws CoreException {
        return Boolean.parseBoolean(configuration.getAttribute("oracle.eclipse.tools.jaxrs.WADL_ENABLE", "true"));
    }

    public String getRequestUrl(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("oracle.eclipse.tools.jaxrs.REQUEST_URL", "");
    }

    public String getResourceClass(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
    }

    public void verifyJaxrsApplicationAvailable(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject jProj = this.getJavaProject(configuration);
        IStatus status = ProjectPathUtil.validateExpectedJaxrsProjectClasspath(jProj);
        if (!status.isOK()) {
            this.abort(status.getMessage(), null, 101);
        }
    }

    private void alreadyInUseDialog(final String port) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                JaxrsApplicationLaunchDelegate.this.setOpenBrowser(MessageDialog.openConfirm((Shell)Activator.getActiveWorkbenchShell(), (String)"Already Running", (String)NLS.bind((String)Messages.errorPortInUse, (Object[])new String[]{String.valueOf(port), "Jaxrs Application"})));
            }
        });
    }

    public boolean isOpenBrowser() {
        return this.openBrowser;
    }

    public void setOpenBrowser(boolean openBrowser) {
        this.openBrowser = openBrowser;
    }
}

