/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt.annotation.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.AnnotationType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.eclipse.tools.jaxrs.jdt.annotation.validation.Messages;
import oracle.eclipse.tools.jaxrs.util.JAXRSDeclarationsUtil;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;

public class PathParamRule
extends AbstractAnnotationProcessor {
    public static final String PATH_PARAM_RULE_STRING = "pathParamRuleError";
    public static final String VARNAME_SEPERATOR = ":";

    public void process() {
        AnnotationTypeDeclaration pathDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration("javax.ws.rs.Path");
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(pathDeclaration);
        HashMap<TypeDeclaration, Set<String>> typeVariableNameMap = new HashMap<TypeDeclaration, Set<String>>();
        for (Declaration declaration : annotatedTypes) {
            if (declaration instanceof TypeDeclaration) {
                Set<String> variableNames = PathParamRule.determineVariableNamesInDeclaration(declaration);
                typeVariableNameMap.put((TypeDeclaration)declaration, variableNames);
            }
            if (!(declaration instanceof MethodDeclaration)) continue;
            Collection modifiers = declaration.getModifiers();
            boolean isPublic = false;
            for (Modifier modifier : modifiers) {
                if (modifier != Modifier.PUBLIC) continue;
                isPublic = true;
                break;
            }
            if (isPublic) continue;
            this.printFixableWarning(declaration.getPosition(), Messages.ResourceMethodVisibilityRule_shouldBePublic, "oracle.eclipse.tools.jaxrs", "changeJaxRSMethodToPublic");
        }
        for (TypeDeclaration typeDeclaration : typeVariableNameMap.keySet()) {
            Collection methodDeclarations = typeDeclaration.getMethods();
            for (MethodDeclaration methodDecl : methodDeclarations) {
                Set typeVariableNames;
                Set variableNames = PathParamRule.determineVariableNamesInDeclaration((Declaration)methodDecl);
                TypeDeclaration declaringType = methodDecl.getDeclaringType();
                if (typeVariableNameMap != null && (typeVariableNames = (Set)typeVariableNameMap.get(declaringType)) != null) {
                    if (variableNames.size() == 0) {
                        variableNames = typeVariableNames;
                    } else {
                        variableNames.addAll(typeVariableNames);
                    }
                }
                this.processMethod(methodDecl, variableNames);
            }
        }
    }

    private void processMethod(MethodDeclaration methodDecl, Set<String> variableNames) {
        Collection parameters = methodDecl.getParameters();
        for (ParameterDeclaration parameterDecl : parameters) {
            Collection paramAnnotationMirrorColl = parameterDecl.getAnnotationMirrors();
            for (AnnotationMirror paramMirror : paramAnnotationMirrorColl) {
                Object paramAnnValue;
                AnnotationValue paramAnnotationValue;
                AnnotationType paramAnnotationType = paramMirror.getAnnotationType();
                AnnotationTypeDeclaration annTypeDecl = paramAnnotationType.getDeclaration();
                if (annTypeDecl == null || !annTypeDecl.getQualifiedName().equals("javax.ws.rs.PathParam") || (paramAnnotationValue = AnnotationUtils.getAnnotationValue((AnnotationMirror)paramMirror, (String)"value")) == null || variableNames.contains((paramAnnValue = paramAnnotationValue.getValue()).toString())) continue;
                String concatString = PathParamRule.getConcatinatedVarNames(variableNames);
                String errorId = concatString.length() > 0 ? "pathParamRuleError:" + concatString : PATH_PARAM_RULE_STRING;
                this.printFixableError(paramAnnotationValue.getPosition(), String.valueOf(Messages.PathParamRule_variableNameError1) + paramAnnValue + Messages.PathParamRule_variableNameError1_2, "oracle.eclipse.tools.jaxrs", errorId);
            }
        }
    }

    private static String getConcatinatedVarNames(Set<String> varNames) {
        StringBuffer sb = new StringBuffer();
        for (String varName : varNames) {
            if (varName.indexOf(VARNAME_SEPERATOR) != -1) {
                return "";
            }
            sb.append(varName);
            sb.append(VARNAME_SEPERATOR);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static Set<String> determineVariableNamesInDeclaration(Declaration declaration) {
        AnnotationValue annotationValue = JAXRSDeclarationsUtil.getAnnotationValue(declaration, "javax.ws.rs.Path", new HashSet<String>());
        if (annotationValue == null) {
            return Collections.emptySet();
        }
        Object pathValue = annotationValue.getValue();
        String strPathValue = pathValue.toString();
        if (strPathValue.indexOf(123) == -1 || strPathValue.toString().indexOf(125) == -1) {
            return Collections.emptySet();
        }
        HashSet<String> variableNames = new HashSet<String>();
        PathParamRule.determineVariableNamesInPath(variableNames, strPathValue);
        return variableNames;
    }

    private static void determineVariableNamesInPath(Set<String> variableNames, String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "{");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String variableName = "";
            int index = token.indexOf(58);
            if (index < 0) {
                index = token.indexOf(125);
            }
            if (index != -1) {
                variableName = token.substring(0, index);
            }
            if (variableName.equals("")) continue;
            variableNames.add(variableName.trim());
        }
    }
}

