/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt.annotation.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import oracle.eclipse.tools.jaxrs.jdt.annotation.validation.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ModifierChangeCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class JaxRSQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 900;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        if (locations == null || locations.length == 0) {
            return null;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList<IJavaCompletionProposal> resultingCollections = new ArrayList<IJavaCompletionProposal>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection<IJavaCompletionProposal> proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id != 900) {
            return;
        }
        String[] problemArgs = problem.getProblemArguments();
        if (problemArgs.length > 1) {
            int firstIndex;
            String errorId = problemArgs[1];
            if (errorId.equals("default_value__annotation_remove_error")) {
                JaxRSQuickFixProcessor.removeAnnotationProposal(context, problem, proposals, "javax.ws.rs.DefaultValue");
            } else if (errorId.equals("encoded_annotation_remove_error")) {
                JaxRSQuickFixProcessor.removeAnnotationProposal(context, problem, proposals, "javax.ws.rs.Encoded");
            } else if (errorId.equals("changeJaxRSMethodToPublic")) {
                JaxRSQuickFixProcessor.addPublicModifierToJaxRSMethod(context, problem, proposals);
            } else if (errorId.startsWith("pathParamRuleError") && !errorId.equals("pathParamRuleError") && errorId.substring(0, firstIndex = errorId.indexOf(":")).equals("pathParamRuleError")) {
                StringTokenizer tokenizer = new StringTokenizer(errorId.substring(firstIndex + 1), ":");
                while (tokenizer.hasMoreTokens()) {
                    String varName = tokenizer.nextToken();
                    proposals.add(new VariableNameCompletionProposal(problem.getOffset(), problem.getLength(), varName));
                }
            }
        }
    }

    private static void addPublicModifierToJaxRSMethod(IInvocationContext context, IProblemLocation problem, Collection<IJavaCompletionProposal> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!((selectedNode = JaxRSQuickFixProcessor.getMethodDeclarationNode(selectedNode)) instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding method = ((MethodDeclaration)selectedNode).resolveBinding();
        int excludedModifiers = 7;
        int includedModifiers = 1;
        proposals.add((IJavaCompletionProposal)new ModifierChangeCorrectionProposal(Messages.JaxRSQuickFixProcessor_changeMethodVisibilityToPublic, cu, (IBinding)method, selectedNode, includedModifiers, excludedModifiers, 8, null));
    }

    private static MethodDeclaration getMethodDeclarationNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof MethodDeclaration) {
            return (MethodDeclaration)node;
        }
        return JaxRSQuickFixProcessor.getMethodDeclarationNode(node.getParent());
    }

    private static void removeAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection<IJavaCompletionProposal> proposals, String annotationName) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        ASTNode annotationNode = JaxRSQuickFixProcessor.getAnnotationASTNode(selectedNode);
        if (annotationNode == null) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)selectedNode.getAST());
        rewrite.remove(annotationNode, null);
        int lastIndexofDot = annotationName.lastIndexOf(46);
        String shortAnnName = lastIndexofDot != -1 ? annotationName.substring(lastIndexofDot + 1) : annotationName;
        String label = String.valueOf(Messages.JaxRSQuickFixProcessor_removeAnnotationMsg) + "@" + shortAnnName;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, null);
        proposals.add((IJavaCompletionProposal)proposal);
    }

    private static ASTNode getAnnotationASTNode(ASTNode node) {
        if (node instanceof Annotation) {
            return node;
        }
        if (node == null) {
            return null;
        }
        return JaxRSQuickFixProcessor.getAnnotationASTNode(node.getParent());
    }

    private static class VariableNameCompletionProposal
    implements IJavaCompletionProposal {
        private int offset;
        private int length;
        private String replacementText;

        public VariableNameCompletionProposal(int offset, int length, String replacementText) {
            this.offset = offset;
            this.length = length;
            this.replacementText = replacementText;
        }

        public void apply(IDocument document) {
            try {
                document.replace(this.offset, this.length, "\"" + this.replacementText + "\"");
            }
            catch (BadLocationException badLocationException) {}
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return Messages.PathParamQuickFixProcessor_additonalProposalInfo;
        }

        public String getDisplayString() {
            return this.replacementText;
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public int getRelevance() {
            return 0;
        }
    }
}

