/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt.annotation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import java.util.Collections;
import oracle.eclipse.tools.jaxrs.jdt.annotation.IJaxrsAnnotation;

public abstract class JaxrsAnnotation
implements IJaxrsAnnotation {
    private final String annotationType;
    private final Declaration declaration;
    private AnnotationMirror annotationMirror = null;

    public JaxrsAnnotation(String annotationType, Declaration declaration) {
        this.annotationType = annotationType;
        this.declaration = declaration;
        this.annotationMirror = JaxrsAnnotation.getAnnotation(declaration, annotationType);
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public String getOwningDeclaration() {
        return this.declaration.getSimpleName();
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    @Override
    public boolean hasAnnotation() {
        return this.annotationMirror != null;
    }

    protected Collection<? extends MethodDeclaration> getMethodDeclarations() {
        if (this.declaration instanceof TypeDeclaration) {
            return ((TypeDeclaration)this.declaration).getMethods();
        }
        return Collections.emptyList();
    }

    protected Collection<FieldDeclaration> getFieldDeclarations() {
        if (this.declaration instanceof TypeDeclaration) {
            return ((TypeDeclaration)this.declaration).getFields();
        }
        return Collections.emptyList();
    }

    protected Collection<ParameterDeclaration> getParameterDeclarations() {
        if (this.declaration instanceof MethodDeclaration) {
            return ((MethodDeclaration)this.declaration).getParameters();
        }
        return Collections.emptyList();
    }

    public static AnnotationMirror getAnnotation(Declaration declaration, String canonicalName) {
        Collection aannotationMirrors = declaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : aannotationMirrors) {
            AnnotationTypeDeclaration annotationTypeDeclaration = annotationMirror.getAnnotationType().getDeclaration();
            if (annotationTypeDeclaration == null || !annotationTypeDeclaration.getQualifiedName().equals(canonicalName)) continue;
            return annotationMirror;
        }
        return null;
    }
}

