/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.jaxrs.jdt.FieldElement;
import oracle.eclipse.tools.jaxrs.jdt.JaxrsElement;
import oracle.eclipse.tools.jaxrs.jdt.MethodElement;
import oracle.eclipse.tools.jaxrs.jdt.annotation.ApplicationPathAnnotation;
import oracle.eclipse.tools.jaxrs.jdt.annotation.ConsumesAnnotation;
import oracle.eclipse.tools.jaxrs.jdt.annotation.EncodedAnnotation;
import oracle.eclipse.tools.jaxrs.jdt.annotation.PathAnnotation;
import oracle.eclipse.tools.jaxrs.jdt.annotation.ProducesAnnotation;
import oracle.eclipse.tools.jaxrs.jdt.annotation.ProviderAnnotation;

public class TypeElement
extends JaxrsElement {
    private PathAnnotation pathAnnotation;
    private ApplicationPathAnnotation applicationPathAnnotation;
    private ConsumesAnnotation consumesAnnotation;
    private ProducesAnnotation producesAnnotation;
    private EncodedAnnotation encodedAnnotation;
    private ProviderAnnotation providerAnnotation;
    private List<MethodElement> methodElements;
    private List<FieldElement> fieldElements;
    private final TypeDeclaration typeDeclaration;

    public TypeElement(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.pathAnnotation = new PathAnnotation((Declaration)this.getTypeDeclaration());
        this.applicationPathAnnotation = new ApplicationPathAnnotation((Declaration)this.getTypeDeclaration());
        this.consumesAnnotation = new ConsumesAnnotation((Declaration)this.getTypeDeclaration());
        this.producesAnnotation = new ProducesAnnotation((Declaration)this.getTypeDeclaration());
        this.encodedAnnotation = new EncodedAnnotation((Declaration)this.getTypeDeclaration());
        this.providerAnnotation = new ProviderAnnotation((Declaration)this.getTypeDeclaration());
        this.methodElements = new ArrayList<MethodElement>();
        Collection<? extends MethodDeclaration> methods = this.getMethodDeclarations();
        for (MethodDeclaration methodDeclaration : methods) {
            this.methodElements.add(new MethodElement(this, methodDeclaration));
        }
        this.fieldElements = new ArrayList<FieldElement>();
        Collection<FieldDeclaration> collection = this.getFieldDeclarations();
        for (FieldDeclaration field : collection) {
            this.fieldElements.add(new FieldElement(this, field));
        }
    }

    public String getSimpleName() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getSimpleName();
        }
        return "";
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    public PathAnnotation getPathAnnotation() {
        return this.pathAnnotation;
    }

    public ApplicationPathAnnotation getApplicationPathAnnotation() {
        return this.applicationPathAnnotation;
    }

    public ConsumesAnnotation getConsumesAnnotation() {
        return this.consumesAnnotation;
    }

    public ProducesAnnotation getProducesAnnotation() {
        return this.producesAnnotation;
    }

    public EncodedAnnotation getEncodedAnnotation() {
        return this.encodedAnnotation;
    }

    public ProviderAnnotation getProviderAnnotation() {
        return this.providerAnnotation;
    }

    public List<MethodElement> getMethodElements() {
        return this.methodElements;
    }

    public List<FieldElement> getFieldElements() {
        return this.fieldElements;
    }

    private Collection<? extends MethodDeclaration> getMethodDeclarations() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getMethods();
        }
        return Collections.emptyList();
    }

    private Collection<FieldDeclaration> getFieldDeclarations() {
        if (this.getTypeDeclaration() != null) {
            return this.getTypeDeclaration().getFields();
        }
        return Collections.emptyList();
    }

    @Override
    public String getUrlSegment() {
        if (this.pathAnnotation.hasAnnotation()) {
            return this.pathAnnotation.getValue();
        }
        return "";
    }

    public List<MethodElement> findGetMethods() {
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
        for (MethodElement method : this.methodElements) {
            if (!method.getGetAnnotation().hasAnnotation()) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<MethodElement> findPutMethods() {
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
        for (MethodElement method : this.methodElements) {
            if (!method.getPutAnnotation().hasAnnotation()) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<MethodElement> findPostMethods() {
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
        for (MethodElement method : this.methodElements) {
            if (!method.getPostAnnotation().hasAnnotation()) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<MethodElement> findDeleteMethods() {
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
        for (MethodElement method : this.methodElements) {
            if (!method.getDeleteAnnotation().hasAnnotation()) continue;
            methods.add(method);
        }
        return methods;
    }

    public List<MethodElement> findHeadMethods() {
        ArrayList<MethodElement> methods = new ArrayList<MethodElement>();
        for (MethodElement method : this.methodElements) {
            if (!method.getHeadAnnotation().hasAnnotation()) continue;
            methods.add(method);
        }
        return methods;
    }

    @Override
    public String getFullUrlSegment() {
        return this.formatUrl(this.getUrlSegment());
    }
}

