/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.jdt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.eclipse.tools.common.util.StatusCollector;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.jaxrs.Activator;
import oracle.eclipse.tools.jaxrs.jdt.JaxrsRuntimeClasspathContainer;
import oracle.eclipse.tools.jaxrs.jdt.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProjectPathUtil {
    private static final String JERSEY_SERVER_RUNTIME_CLASS = "com.sun.jersey.api.container.httpserver.HttpServerFactory";
    private static final String JERSEY_CLIENT_RUNTIME_CLASS = "com.sun.jersey.api.client.Client";
    private static final String JERSEY_CORE_RUNTIME_CLASS = "com.sun.jersey.api.provider.jaxb.XmlHeader";
    private static final String JERSEY_JSON_RUNTIME_CLASS = "com.sun.jersey.api.json.JSONConfigurated";
    private static final String JERSEY_SERVLET_RUNTIME_CLASS = "com.sun.jersey.api.core.servlet.WebAppResourceConfig";
    private static final String JSR311_API_CLASS = "javax.ws.rs.Path";
    private static final String ASM_CLASS = "org.objectweb.asm.Type";
    private static int MAXLINE = 511;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String LIST_SEPARATOR = "," + LINE_SEPARATOR + " ";
    private static final String RUNTIME_DEP_RUNTIME_COMMON = "oracle.eclipse.tools.jaxrs";
    private static final String JERSEY_JAVADOC_PLUGIN_ID = "oracle.eclipse.tools.jaxrs";
    private static final String JERSEY_JAVADOC_RELATIVE_PATH = "lib/v11/apidocs/jersey";
    public static final String CLASSPATH_CONTAINER_ID = "oracle.eclipse.tools.jaxrs.ui.runtimeClasspathContainer";
    public static final String JAXRS11 = "v1.1";

    public static void appendProjectBuildPath(IJavaProject targetProject, IJavaProject sourceProject) throws CoreException {
        block4: {
            try {
                IClasspathEntry[] srcEntries = sourceProject.getRawClasspath();
                int i = 0;
                while (i < srcEntries.length) {
                    IClasspathEntry entry = srcEntries[i];
                    if (!entry.isExported() && entry.getEntryKind() != 3) {
                        ProjectPathUtil.addToClasspath(targetProject, entry);
                    }
                    ++i;
                }
                IClasspathEntry srcPrjEntry = JavaCore.newProjectEntry((IPath)sourceProject.getPath());
                ProjectPathUtil.addToClasspath(targetProject, srcPrjEntry);
            }
            catch (JavaModelException e) {
                if (!(e.getCause() instanceof CoreException)) break block4;
                throw (CoreException)e.getCause();
            }
        }
    }

    public static void addRuntimeJarToBuildPath(IJavaProject project, String workspaceProject, String variable, String jarName) throws CoreException {
        IClasspathEntry entry = ProjectPathUtil.getEntry(workspaceProject, variable, jarName);
        ProjectPathUtil.addToClasspath(project, entry);
    }

    public static IClasspathEntry getEntry(String workspaceProject, String variable, String jarName) {
        IClasspathEntry entry;
        IProject wsJavaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(workspaceProject);
        if (wsJavaProject.exists()) {
            entry = JavaCore.newProjectEntry((IPath)wsJavaProject.getFullPath());
        } else {
            Path variablePath = new Path(variable);
            if (jarName != null) {
                variablePath = variablePath.append(jarName);
            }
            entry = JavaCore.newVariableEntry((IPath)variablePath, null, null);
        }
        return entry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClasspathEntry getEntry(String bundleName, String jarName, boolean hasJavadoc) {
        IProject wsJavaProject = ResourcesPlugin.getWorkspace().getRoot().getProject(bundleName);
        if (wsJavaProject.exists()) {
            return JavaCore.newProjectEntry((IPath)wsJavaProject.getFullPath());
        }
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            return null;
        }
        try {
            Path path2 = new Path(ProjectPathUtil.getFullPath(bundle.getEntry("/")));
            return JavaCore.newLibraryEntry((IPath)new Path(path2 + jarName), null, null);
        }
        catch (CoreException e1) {
            URL location;
            Bundle docBundle;
            String path;
            e1.printStackTrace();
            try {
                URL location2 = bundle.getEntry(jarName);
                URL jarLocation = null;
                if (location2 == null) {
                    location2 = bundle.getEntry("/");
                    jarLocation = FileLocator.resolve((URL)location2);
                    if (!jarLocation.getFile().endsWith(".jar!/")) {
                        return null;
                    }
                    jarLocation = new URL(jarLocation.getPath());
                } else {
                    jarLocation = FileLocator.resolve((URL)location2);
                }
                path = jarLocation.getFile();
                if (path.endsWith(".jar!/")) {
                    path = path.substring(0, path.length() - 2);
                }
            }
            catch (IOException e) {
                LoggingService.logException((String)Activator.getPluginId(), (Throwable)e);
                return null;
            }
            IClasspathAttribute[] attributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
            if (hasJavadoc && (docBundle = Platform.getBundle((String)"oracle.eclipse.tools.jaxrs")) != null && (location = bundle.getEntry(JERSEY_JAVADOC_RELATIVE_PATH)) != null) {
                attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)location.toExternalForm())};
            }
            return JavaCore.newLibraryEntry((IPath)new Path(path), null, null, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])attributes, (boolean)false);
        }
    }

    public static void addPluginJarToBuildPath(IJavaProject project, String pluginId) throws CoreException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            LoggingService.logWarning((String)Activator.getPluginId(), (String)("Cannot find Bundle " + pluginId));
            return;
        }
        Path path = new Path(ProjectPathUtil.getFullPath(bundle.getEntry("/")));
        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null);
        ProjectPathUtil.addToClasspath(project, entry);
    }

    public static List<String> getClasspathPaths(String pluginID) throws CoreException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ManifestElement[] elements;
            Bundle bundle = Platform.getBundle((String)pluginID);
            String requires = (String)bundle.getHeaders().get("Bundle-ClassPath");
            if (requires == null) {
                requires = ".";
            }
            if ((elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires)) != null) {
                int i = 0;
                while (i < elements.length) {
                    URL url;
                    ManifestElement element = elements[i];
                    String value = element.getValue();
                    if (".".equals(value)) {
                        value = "/";
                    }
                    if ((url = bundle.getEntry(value)) != null) {
                        result.add(ProjectPathUtil.getFullPath(url));
                    }
                    ++i;
                }
            }
        }
        catch (BundleException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
        return result;
    }

    public static String getFullPath(URL url) throws CoreException {
        try {
            URL resolvedURL = FileLocator.resolve((URL)url);
            String resolvedURLString = resolvedURL.toString();
            if (resolvedURLString.endsWith("!/")) {
                resolvedURLString = resolvedURL.getFile();
                resolvedURLString = resolvedURLString.substring(0, resolvedURLString.length() - "!/".length());
            }
            if (resolvedURLString.startsWith("file:")) {
                return resolvedURLString.substring("file:".length());
            }
            return FileLocator.toFileURL((URL)url).getFile();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    public static void addToClasspath(IJavaProject project, IClasspathEntry entry) throws CoreException {
        block6: {
            IClasspathEntry[] oldEntries = project.getRawClasspath();
            int i = 0;
            while (i < oldEntries.length) {
                if (oldEntries[i].equals(entry)) {
                    return;
                }
                ++i;
            }
            int nEntries = oldEntries.length;
            IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
            newEntries[nEntries] = entry;
            try {
                try {
                    project.setRawClasspath(newEntries, null);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof CoreException)) break block6;
                throw (CoreException)t;
            }
        }
    }

    public static void addPluginDependency(IJavaProject targetProject, String pluginId) throws CoreException {
        IFile manifest = targetProject.getProject().getFile("META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            ProjectPathUtil.updateManifestDependency(manifest.getLocation().toFile(), pluginId);
            manifest.refreshLocal(1, null);
        } else {
            IFile plugin = targetProject.getProject().getFile("plugin.xml");
            if (!plugin.exists()) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), "No plugin or manifest file found in target project", null));
            }
            ProjectPathUtil.updatePluginDependnecy(plugin.getLocation().toFile(), pluginId);
            plugin.refreshLocal(1, null);
        }
    }

    public static void updatePluginDependnecy(File plugin, String pluginId) throws CoreException {
        try {
            Document doc = ProjectPathUtil.parseXmlFile(plugin, false);
            NodeList list = doc.getElementsByTagName("requires");
            int i = 0;
            while (i < list.getLength()) {
                Element element = (Element)list.item(i);
                Element importElement = doc.createElement("import");
                importElement.setAttribute("plugin", pluginId);
                element.appendChild(importElement);
                ++i;
            }
            ProjectPathUtil.writeXmlFile(doc, plugin);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    public static Document parseXmlFile(File file, boolean validating) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        Document doc = factory.newDocumentBuilder().parse(file);
        return doc;
    }

    public static void writeXmlFile(Document doc, File file) throws Exception {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
    }

    public static void updateManifestDependency(File file, String pluginId) throws CoreException {
        FileInputStream manifestStream = null;
        try {
            try {
                manifestStream = new FileInputStream(file);
                Manifest manifest = new Manifest(manifestStream);
                Properties prop = ProjectPathUtil.manifestToProperties(manifest.getMainAttributes());
                String require = prop.getProperty("Require-Bundle");
                if (require == null || require.trim().equals("")) {
                    prop.put("Require-Bundle", pluginId);
                } else {
                    boolean exists = false;
                    ManifestElement[] elements = ManifestElement.parseHeader((String)"Require-Bundle", (String)require);
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i].getValue().equals(pluginId)) {
                            exists = true;
                        }
                        ProjectPathUtil.appendValue(buffer, elements[i].getValue());
                        ++i;
                    }
                    if (!exists) {
                        ProjectPathUtil.appendValue(buffer, pluginId);
                    }
                    prop.put("Require-Bundle", buffer.toString());
                }
                ProjectPathUtil.writeManifest(file, prop);
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
            }
            catch (BundleException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (manifestStream != null) {
                    ((InputStream)manifestStream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (manifestStream != null) {
                ((InputStream)manifestStream).close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void writeManifest(File generationLocation, Dictionary manifestToWrite) throws CoreException {
        Writer out = null;
        try {
            try {
                File parentFile = new File(generationLocation.getParent());
                parentFile.mkdirs();
                generationLocation.createNewFile();
                if (!generationLocation.isFile()) {
                    throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), "Location must be a file.", null));
                }
                manifestToWrite = new Hashtable(manifestToWrite);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(generationLocation), StandardCharsets.UTF_8));
                Enumeration keys = ((Dictionary)manifestToWrite).keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    ProjectPathUtil.writeEntry(out, key, (String)((Dictionary)manifestToWrite).get(key));
                }
                out.flush();
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), "Error when building bundle manifets", null));
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeBuildProperties(File generationLocation, Dictionary propertiesToWrite) throws CoreException {
        Writer out = null;
        try {
            try {
                File parentFile = new File(generationLocation.getParent());
                parentFile.mkdirs();
                generationLocation.createNewFile();
                if (!generationLocation.isFile()) {
                    throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), "Location must be a file.", null));
                }
                propertiesToWrite = new Hashtable(propertiesToWrite);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(generationLocation), StandardCharsets.UTF_8));
                Enumeration keys = ((Dictionary)propertiesToWrite).keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    ProjectPathUtil.writePropertyEntry(out, key, (String)((Dictionary)propertiesToWrite).get(key));
                }
                out.flush();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), "Error when writing properties file", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void writePropertyEntry(Writer out, String key, String value) throws IOException {
        if (value != null && value.length() > 0) {
            out.write(ProjectPathUtil.splitOnComma(String.valueOf(key) + "= " + value));
            out.write(LINE_SEPARATOR);
        }
    }

    private static void writeEntry(Writer out, String key, String value) throws IOException {
        if (value != null && value.length() > 0) {
            out.write(ProjectPathUtil.splitOnComma(String.valueOf(key) + ": " + value));
            out.write(LINE_SEPARATOR);
        }
    }

    private static String splitOnComma(String value) {
        if (value.length() < MAXLINE || value.indexOf(LINE_SEPARATOR) >= 0) {
            return value;
        }
        String[] values = ProjectPathUtil.getArrayFromList(value);
        if (values == null || values.length == 0) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value.length() + (values.length - 1) * LIST_SEPARATOR.length());
        int i = 0;
        while (i < values.length - 1) {
            sb.append(values[i]).append(LIST_SEPARATOR);
            ++i;
        }
        sb.append(values[values.length - 1]);
        return sb.toString();
    }

    public static String[] getArrayFromList(String stringList) {
        if (stringList == null || stringList.trim().equals("")) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(stringList, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    private static void appendValue(StringBuffer buffer, String value) {
        if (buffer.length() > 0) {
            buffer.append(LIST_SEPARATOR);
        }
        buffer.append(value);
    }

    private static Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public static IStatus validateDependencies(IJavaProject targetProject, boolean addDefault, boolean isRcpApplication) {
        Status status = new Status(0, "oracle.eclipse.tools.jaxrs", 0, "Project has all libraires", null);
        boolean addJerseyServerJar = ProjectPathUtil.checkToAddEntry(targetProject, JERSEY_SERVER_RUNTIME_CLASS);
        boolean addJerseyCoreJar = ProjectPathUtil.checkToAddEntry(targetProject, JERSEY_CORE_RUNTIME_CLASS);
        boolean addJerseyClientJar = ProjectPathUtil.checkToAddEntry(targetProject, JERSEY_CLIENT_RUNTIME_CLASS);
        boolean addJerseyJsonJar = ProjectPathUtil.checkToAddEntry(targetProject, JERSEY_JSON_RUNTIME_CLASS);
        boolean addJerseyServletJar = ProjectPathUtil.checkToAddEntry(targetProject, JERSEY_SERVLET_RUNTIME_CLASS);
        boolean addJSR311Jar = ProjectPathUtil.checkToAddEntry(targetProject, JSR311_API_CLASS);
        boolean addAsmJar = ProjectPathUtil.checkToAddEntry(targetProject, ASM_CLASS);
        if (!(addJerseyServerJar || addJerseyCoreJar || addJerseyClientJar || addJerseyJsonJar || addJerseyServletJar || addJSR311Jar || addAsmJar)) {
            return status;
        }
        if (addDefault) {
            try {
                ProjectPathUtil.addToClasspath(targetProject, JavaCore.newContainerEntry((IPath)new Path(CLASSPATH_CONTAINER_ID), (boolean)false));
                return status;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return new Status(2, Activator.getPluginId(), 2, "Some required libraries are missing.", null);
    }

    public static IClasspathEntry getRuntimeContainerEntry(IJavaProject targetProject) throws JavaModelException {
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)new Path(CLASSPATH_CONTAINER_ID), (boolean)false);
        IClasspathEntry[] entries = ProjectPathUtil.getRuntimeClasspathEntries(targetProject);
        JavaCore.setClasspathContainer((IPath)entry.getPath(), (IJavaProject[])new IJavaProject[]{targetProject}, (IClasspathContainer[])new IClasspathContainer[]{new JaxrsRuntimeClasspathContainer(entries, entry.getPath())}, null);
        return entry;
    }

    public static IStatus validateDependencies(IJavaProject targetProject, String mainAppProjectName, boolean addDefault, boolean isRcpApplication) throws CoreException {
        IProject mainAppProject = ResourcesPlugin.getWorkspace().getRoot().getProject(mainAppProjectName);
        if (!targetProject.getProject().getName().equals(mainAppProjectName) && addDefault) {
            ProjectPathUtil.appendProjectBuildPath(targetProject, JavaCore.create((IProject)mainAppProject));
        }
        if (!targetProject.getProject().getName().equals(mainAppProjectName) && !addDefault) {
            return new Status(2, Activator.getPluginId(), 2, "Some required libraries are missing.", null);
        }
        return ProjectPathUtil.validateDependencies(targetProject, addDefault, isRcpApplication);
    }

    public static IClasspathEntry[] getRuntimeClasspathEntries(IJavaProject targetProject) {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        ProjectPathUtil.checkAndAddEntry(targetProject, entries, JERSEY_SERVER_RUNTIME_CLASS, "oracle.eclipse.tools.jaxrs", "lib/v1.1/jersey-server.jar", true);
        ProjectPathUtil.checkAndAddEntry(targetProject, entries, JERSEY_CORE_RUNTIME_CLASS, "oracle.eclipse.tools.jaxrs", "lib/v1.1/jersey-core.jar", true);
        ProjectPathUtil.checkAndAddEntry(targetProject, entries, JERSEY_CLIENT_RUNTIME_CLASS, "oracle.eclipse.tools.jaxrs", "lib/v1.1/jersey-client.jar", true);
        ProjectPathUtil.checkAndAddEntry(targetProject, entries, JERSEY_JSON_RUNTIME_CLASS, "oracle.eclipse.tools.jaxrs", "lib/v1.1/jersey-json.jar", true);
        ProjectPathUtil.checkAndAddEntry(targetProject, entries, JERSEY_SERVLET_RUNTIME_CLASS, "oracle.eclipse.tools.jaxrs", "lib/v1.1/jersey-servlet.jar", true);
        ProjectPathUtil.checkAndAddEntry(targetProject, entries, JSR311_API_CLASS, "oracle.eclipse.tools.jaxrs", "lib/v1.1/jsr311.jar", true);
        ProjectPathUtil.checkAndAddEntry(targetProject, entries, ASM_CLASS, "oracle.eclipse.tools.jaxrs", "lib/v1.1/asm-3.1.jar", true);
        return entries.toArray(new IClasspathEntry[0]);
    }

    public static List<String> getExpectedJerseyClassList() {
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(JERSEY_SERVER_RUNTIME_CLASS);
        entries.add(JERSEY_CORE_RUNTIME_CLASS);
        entries.add(JERSEY_CLIENT_RUNTIME_CLASS);
        entries.add(JERSEY_JSON_RUNTIME_CLASS);
        entries.add(JERSEY_SERVLET_RUNTIME_CLASS);
        entries.add(JSR311_API_CLASS);
        entries.add(ASM_CLASS);
        return entries;
    }

    public static List<String> getExpectedJaxrsClassList() {
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(JSR311_API_CLASS);
        return entries;
    }

    private static void checkAndAddEntry(IJavaProject targetProject, ArrayList<IClasspathEntry> entries, String classToCheck, String bundle, String jarName, boolean hasJavadoc) {
        IClasspathEntry entry;
        if (ProjectPathUtil.checkToAddEntry(targetProject, classToCheck) && (entry = ProjectPathUtil.getEntry(bundle, jarName, hasJavadoc)) != null) {
            entries.add(entry);
        }
    }

    private static boolean checkToAddEntry(IJavaProject targetProject, String classToCheck) {
        boolean required = true;
        return required;
    }

    public static IStatus validateProjectClassEntry(IJavaProject targetProject, String classToCheck) {
        try {
            if (targetProject.findType(classToCheck) == null) {
                return new Status(4, Activator.getPluginId(), NLS.bind((String)Messages.project_classpath_error, (Object)classToCheck, (Object)targetProject.getProject().getName()), null);
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException((String)NLS.bind((String)Messages.exception_validating_classpath, (Object)classToCheck, (Object)targetProject.getProject().getName()), (CoreException)((Object)e));
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateExpectedJerseyProjectClasspath(IJavaProject jProject) {
        List<String> entries = ProjectPathUtil.getExpectedJerseyClassList();
        StatusCollector statusCollector = new StatusCollector("oracle.eclipse.tools.jaxrs");
        for (String entry : entries) {
            IStatus status = ProjectPathUtil.validateProjectClassEntry(jProject, entry);
            if (status.isOK()) continue;
            statusCollector.add(status);
        }
        return statusCollector.getStatus();
    }

    public static IStatus validateExpectedJaxrsProjectClasspath(IJavaProject jProject) {
        List<String> entries = ProjectPathUtil.getExpectedJaxrsClassList();
        StatusCollector statusCollector = new StatusCollector("oracle.eclipse.tools.jaxrs");
        for (String entry : entries) {
            IStatus status = ProjectPathUtil.validateProjectClassEntry(jProject, entry);
            if (status.isOK()) continue;
            statusCollector.add(status);
        }
        return statusCollector.getStatus();
    }
}

