/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.descriptors;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.eclipse.tools.jaxrs.descriptors.JAXRSUtilFactory;
import oracle.eclipse.tools.jaxrs.descriptors.JAXRSUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.j2ee.model.IModelProvider;

public class JAXRSWebXml {
    public static final String JAXRS_JERSEY_SERVLET_CLASS = "com.sun.jersey.spi.container.servlet.ServletContainer";
    public static final String JAXRS_WEBLOGIC_SERVLET_CLASS = "weblogic.jaxrs.server.portable.servlet.ServletContainer";

    public List<String> findUrlPatternMappings(IResource resource) {
        JAXRSUtils jaxrsUtil = new JAXRSUtilFactory().create(resource.getProject());
        IModelProvider provider = jaxrsUtil.getModelProvider();
        Object webApp = provider.getModelObject();
        ArrayList<String> mergeList = new ArrayList<String>();
        if (jaxrsUtil != null && webApp != null) {
            List<String> jerseyUrlPatterns = jaxrsUtil.findUrlPatternMappings(webApp, JAXRS_JERSEY_SERVLET_CLASS);
            List<String> wlsUrlPatterns = jaxrsUtil.findUrlPatternMappings(webApp, JAXRS_WEBLOGIC_SERVLET_CLASS);
            mergeList.addAll(jerseyUrlPatterns);
            mergeList.addAll(wlsUrlPatterns);
        }
        return mergeList;
    }

    public String findContextRoot(IProject project) {
        List<String> urlPatterns = this.findUrlPatternMappings((IResource)project);
        Pattern url = Pattern.compile("[/].*[/\\*]");
        for (String urlPattern : urlPatterns) {
            if (!url.matcher(urlPattern).matches()) continue;
            int lastStar = urlPattern.lastIndexOf("*");
            return lastStar == -1 ? urlPattern : urlPattern.substring(0, lastStar);
        }
        return null;
    }
}

