/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.descriptors;

import java.util.List;
import oracle.eclipse.tools.jaxrs.descriptors.J2EEUtils;
import oracle.eclipse.tools.jaxrs.descriptors.JEEUtils;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;

public abstract class JAXRSUtils {
    private final IModelProvider _modelProvider;

    protected JAXRSUtils(IModelProvider modelProvider) {
        this._modelProvider = modelProvider;
    }

    public final IModelProvider getModelProvider() {
        Object webAppObj = this._modelProvider.getModelObject();
        if (webAppObj == null) {
            return null;
        }
        return this._modelProvider;
    }

    public boolean isJavaEE(Object webAppObj) {
        if (webAppObj instanceof WebApp) {
            WebApp webApp = (WebApp)webAppObj;
            return WebAppVersionType.VALUES.contains(webApp.getVersion());
        }
        return false;
    }

    protected Object findJAXRSServlet(Object webApp, String servletClass) {
        if (this.isJavaEE(webApp)) {
            return JEEUtils.findServlet((WebApp)webApp, servletClass);
        }
        return J2EEUtils.findServlet((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, servletClass);
    }

    public List<String> findUrlPatternMappings(Object webApp, String servletClass) {
        if (this.isJavaEE(webApp)) {
            return JEEUtils.findURLMappings((WebApp)webApp, servletClass);
        }
        return J2EEUtils.findURLMappings((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, servletClass);
    }
}

