/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.ModuleCoreSupport;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.html.core.internal.validate.StringMatcher;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.validate.ErrorInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class HTMLAttributeValidator
extends PrimeValidator {
    private static final String JAVASCRIPT_PREFIX = "javascript:";
    private static final int REGION_NAME = 1;
    private static final int REGION_VALUE = 2;
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private IPreferencesService fPreferenceService = Platform.getPreferencesService();
    private static Map fIgnorePatterns = new HashMap();
    private static final String ATTR_NAME_DATA = "data-";
    private static final int ATTR_NAME_DATA_LENGTH = "data-".length();
    private static final String ATTR_NAME_USER_AGENT_FEATURE = "x-";
    private static final int ATTR_NAME_USER_AGENT_FEATURE_LENGTH = "x-".length();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private Segment getErrorSegment(IDOMNode errorNode, int regionType) {
        IStructuredDocumentRegion firstRegion;
        IDOMElement ownerElement;
        ITextRegion rgn = null;
        switch (regionType) {
            case 1: {
                rgn = errorNode.getNameRegion();
                break;
            }
            case 2: {
                rgn = errorNode.getValueRegion();
                break;
            }
        }
        if (rgn != null && errorNode instanceof IDOMAttr && (ownerElement = (IDOMElement)((IDOMAttr)errorNode).getOwnerElement()) != null && (firstRegion = ownerElement.getFirstStructuredDocumentRegion()) != null) {
            int regionStartOffset = firstRegion.getStartOffset(rgn);
            int regionLength = rgn.getTextLength();
            return new Segment(regionStartOffset, regionLength);
        }
        return new Segment(errorNode.getStartOffset(), 1);
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.html.core.internal.validate.HTMLAttributeValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion node) {
        Element target = (Element)node;
        if (CMUtil.isForeign(target)) {
            return;
        }
        CMElementDeclaration edec = CMUtil.getDeclaration(target);
        if (edec == null) {
            return;
        }
        CMNamedNodeMap declarations = edec.getAttributes();
        List modelQueryNodes = null;
        NamedNodeMap attrs = target.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            block33: {
                Segment seg;
                Attr a;
                int state;
                int rgnType;
                block35: {
                    String source;
                    CMAttributeDeclaration adec;
                    boolean isXMLAttr;
                    block37: {
                        String desired;
                        block36: {
                            block34: {
                                IDOMAttr xmlattr;
                                rgnType = 1;
                                state = 0;
                                a = (Attr)attrs.item(i);
                                isXMLAttr = a instanceof IDOMAttr;
                                if (isXMLAttr && (!(xmlattr = (IDOMAttr)a).isGlobalAttr() || xmlattr.getNameRegion() instanceof ITextRegionContainer)) break block33;
                                adec = (CMAttributeDeclaration)declarations.getNamedItem(a.getName());
                                String attrName = a.getName().toLowerCase(Locale.US);
                                if (adec == null) {
                                    if (modelQueryNodes == null) {
                                        modelQueryNodes = ModelQueryUtil.getModelQuery((Document)target.getOwnerDocument()).getAvailableContent((Element)node, edec, 1);
                                    }
                                    int k = 0;
                                    while (k < modelQueryNodes.size()) {
                                        CMNode cmnode = (CMNode)modelQueryNodes.get(k);
                                        if (cmnode.getNodeType() == 2 && cmnode.getNodeName().toLowerCase(Locale.US).equals(attrName)) {
                                            adec = (CMAttributeDeclaration)cmnode;
                                            break;
                                        }
                                        ++k;
                                    }
                                }
                                if (adec != null) break block34;
                                if ((attrName.startsWith(ATTR_NAME_DATA) && attrName.length() > ATTR_NAME_DATA_LENGTH || attrName.startsWith(ATTR_NAME_USER_AGENT_FEATURE) && attrName.length() > ATTR_NAME_USER_AGENT_FEATURE_LENGTH) && this.isHTML5(target) || !this.shouldValidateAttributeName(target, attrName)) break block33;
                                if (!this.hasNestedRegion(((IDOMNode)a).getNameRegion())) {
                                    rgnType = 1;
                                    state = 11;
                                }
                                break block35;
                            }
                            if (CMUtil.isObsolete((CMNode)adec)) {
                                state = 14;
                            }
                            if (!CMUtil.isHTML(edec) || CMUtil.isXHTML(edec)) break block36;
                            if (!CMUtil.isBooleanAttr(adec) || !((IDOMAttr)a).hasNameOnly()) break block37;
                            break block33;
                        }
                        String actual = a.getName();
                        if (!actual.equals(desired = adec.getAttrName())) {
                            rgnType = 1;
                            state = 103;
                        }
                    }
                    if (state == 0) {
                        ITextRegion region;
                        CMDataType attrType = adec.getAttrType();
                        if (a instanceof IDOMAttr && (region = ((IDOMAttr)a).getEqualRegion()) == null) {
                            rgnType = 1;
                            state = 16;
                        }
                        String actualValue = a.getValue();
                        if (attrType.getImpliedValueKind() == 2) {
                            String validValue = attrType.getImpliedValue();
                            if (!actualValue.equals(validValue)) {
                                rgnType = 2;
                                state = 12;
                            }
                        } else if ("URI".equals(attrType.getDataTypeName())) {
                            Path basePath;
                            Collection dependencies;
                            IStructuredDocumentRegion start;
                            if (actualValue.indexOf(35) < 0 && actualValue.indexOf(":/") < 0 && !actualValue.toLowerCase(Locale.ENGLISH).startsWith(JAVASCRIPT_PREFIX) && CMUtil.isHTML(edec) && (start = ((IDOMNode)node).getStartStructuredDocumentRegion()) != null && start.getFirstRegion().getTextLength() == 1 && (dependencies = (Collection)((IDOMNode)((IDOMNode)node).getOwnerDocument()).getUserData("org.eclipse.wst.html.validator.dependencies")) != null && (basePath = new Path(((IDOMNode)node).getModel().getBaseLocation())).segmentCount() > 1) {
                                IPath path = ModuleCoreSupport.resolve((IPath)basePath, actualValue);
                                IResource found = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                                if (found != null) {
                                    dependencies.add(found);
                                }
                            }
                        } else if ("ENUM".equals(attrType.getDataTypeName())) {
                            String[] enumeratedValues = attrType.getEnumeratedValues();
                            boolean found = false;
                            int j = 0;
                            while (j < enumeratedValues.length) {
                                if (actualValue.equalsIgnoreCase(enumeratedValues[j])) {
                                    found = true;
                                    if (!CMUtil.isCaseSensitive(edec) || actualValue.equals(enumeratedValues[j])) break;
                                    rgnType = 2;
                                    state = 13;
                                    break;
                                }
                                ++j;
                            }
                            if (!found) {
                                String[] modelQueryExtensionValues = ModelQueryUtil.getModelQuery((Document)target.getOwnerDocument()).getPossibleDataTypeValues((Element)node, (CMNode)adec);
                                int j2 = 0;
                                while (j2 < modelQueryExtensionValues.length) {
                                    if (actualValue.equalsIgnoreCase(modelQueryExtensionValues[j2])) {
                                        found = true;
                                        if (!CMUtil.isCaseSensitive(edec) || actualValue.equals(modelQueryExtensionValues[j2])) break;
                                        rgnType = 2;
                                        state = 13;
                                        break;
                                    }
                                    ++j2;
                                }
                                if (!this.hasNestedRegion(((IDOMNode)a).getValueRegion())) {
                                    rgnType = 2;
                                    state = 12;
                                }
                            }
                        }
                    }
                    if (state == 0 && isXMLAttr && (source = ((IDOMAttr)a).getValueRegionText()) != null) {
                        char firstChar = source.charAt(0);
                        char lastChar = source.charAt(source.length() - 1);
                        boolean unclosedAttr = false;
                        if (this.isQuote(firstChar) || this.isQuote(lastChar)) {
                            if (lastChar != firstChar) {
                                unclosedAttr = true;
                            }
                        } else if (CMUtil.isXHTML(edec)) {
                            unclosedAttr = true;
                        }
                        if (unclosedAttr) {
                            rgnType = 2;
                            state = 113;
                        }
                    }
                }
                if (state != 0 && (seg = this.getErrorSegment((IDOMNode)a, rgnType)) != null) {
                    this.reporter.report((ErrorInfo)new ErrorInfoImpl(state, seg, a));
                }
            }
            ++i;
        }
    }

    private boolean hasNestedRegion(ITextRegion container) {
        if (!(container instanceof ITextRegionContainer)) {
            return false;
        }
        ITextRegionList regions = ((ITextRegionContainer)container).getRegions();
        return regions != null;
    }

    private boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    private boolean isHTML5(Element target) {
        DocumentTypeAdapter documentTypeAdapter;
        INodeNotifier iNodeNotifier = (INodeNotifier)target.getOwnerDocument();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (documentTypeAdapter = (DocumentTypeAdapter)iNodeNotifier.getAdapterFor((Object)clazz)) != null && documentTypeAdapter.hasFeature("HTML5");
    }

    private boolean shouldValidateAttributeName(Element target, String attrName) {
        Object object;
        if (target instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = iAdaptable.getAdapter((Class)clazz);
        } else {
            object = null;
        }
        Object adapter = object;
        IProject project = adapter instanceof IResource ? ((IResource)adapter).getProject() : null;
        Iterator excludedAttributes = this.getExcludedAttributeNames(project).iterator();
        while (excludedAttributes.hasNext()) {
            String excluded = (String)excludedAttributes.next();
            StringMatcher strMatcher = (StringMatcher)fIgnorePatterns.get(excluded);
            if (strMatcher == null) {
                strMatcher = new StringMatcher(excluded);
                fIgnorePatterns.put(excluded, strMatcher);
            }
            if (!strMatcher.match(attrName.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private Set getExcludedAttributeNames(IProject project) {
        ProjectScope projectScope;
        IScopeContext[] fLookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        if (project != null && (projectScope = new ProjectScope(project)).getNode(HTMLCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("use-project-settings", false)) {
            fLookupOrder = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        HashSet<String> result = new HashSet<String>();
        if (this.fPreferenceService.getBoolean(HTMLCorePlugin.getDefault().getBundle().getSymbolicName(), "ignoreAttrNames", false, fLookupOrder)) {
            String ignoreList = this.fPreferenceService.getString(HTMLCorePlugin.getDefault().getBundle().getSymbolicName(), "attrNamesToIgnore", "", fLookupOrder);
            if (ignoreList.trim().length() == 0) {
                return result;
            }
            String[] names = ignoreList.split(",");
            int i = 0;
            while (names != null && i < names.length) {
                String name;
                String string = name = names[i] == null ? null : names[i].trim();
                if (name != null && name.length() > 0) {
                    result.add(name.toLowerCase());
                }
                ++i;
            }
        }
        return result;
    }
}

