/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.variables;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.eclipse.tools.adf.view.variables.BindingsVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public final class BindingsVariableCache {
    private final ConcurrentMap<IFile, BindingsVariable> pageDefToBindingsVarMap = new ConcurrentHashMap<IFile, BindingsVariable>();
    private static final BindingsVariableCache cache = new BindingsVariableCache();

    private BindingsVariableCache() {
    }

    public static BindingsVariableCache getInstance() {
        return cache;
    }

    public BindingsVariable getBindingsVariable(IFile pageDefFile) {
        return (BindingsVariable)((Object)this.pageDefToBindingsVarMap.get(pageDefFile));
    }

    public void setBindingsVariable(IFile pageDefFile, BindingsVariable bindingsVar) {
        this.pageDefToBindingsVarMap.put(pageDefFile, bindingsVar);
    }

    public void removeBindingFileEntry(IFile pagedefFile) {
        this.pageDefToBindingsVarMap.remove(pagedefFile);
    }

    public void removeAllBindingEntriesForProject(IProject project) {
        for (IFile file : this.pageDefToBindingsVarMap.keySet()) {
            if (!file.getProject().equals((Object)project)) continue;
            this.pageDefToBindingsVarMap.remove(file);
        }
    }
}

