/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.variables;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IELField;
import oracle.eclipse.tools.adf.dtrt.object.IELMetadata;
import oracle.eclipse.tools.adf.dtrt.object.IELMethod;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.object.IELPropertyProvider;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ILabeledMember;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.jsf.context.IModelContext;

public class BindingsVariable
extends Variable {
    private static final String VAR_NAME = "bindings";
    private static final long serialVersionUID = 1L;

    public BindingsVariable(Project project, IFile pagedefFile, ResourceLocation definitionLocation) {
        super(VAR_NAME, (DataType)new BindingsVariableDataType(pagedefFile, project), Variable.SCOPE.PAGE_SCOPE, ResolutionTime.PAGE_RUN_OR_COMPILE, definitionLocation);
    }

    public BindingsVariable(Project project, IPageDefinition pageDefinition, ResourceLocation definitionLocation) {
        super(VAR_NAME, (DataType)new BindingsVariableDataType(pageDefinition, project, definitionLocation != null ? (IFile)definitionLocation.getResource() : null), Variable.SCOPE.PAGE_SCOPE, ResolutionTime.PAGE_RUN_OR_COMPILE, definitionLocation);
    }

    public static final class BindingsVariableDataType
    extends DataType {
        private static final long serialVersionUID = 1L;
        private IFile pagedefFile = null;
        private transient boolean isWorkingCopy = false;
        private transient IPageDefinition pageDefinition = null;

        private BindingsVariableDataType(IFile pagedefFile, Project _project) {
            super(null, BindingsVariable.VAR_NAME, _project);
            this.pagedefFile = pagedefFile;
        }

        public BindingsVariableDataType(IPageDefinition pageDefinition, Project _project, IFile pageDefFile) {
            super(null, BindingsVariable.VAR_NAME, _project);
            this.pageDefinition = pageDefinition;
            this.pagedefFile = pageDefFile;
            this.isWorkingCopy = true;
        }

        public List<DataType.Field> getFields(IModelContext modelContext) {
            List fields = super.getFields(modelContext);
            if (fields == null || fields.size() == 0) {
                IObjectLocator locator = ADFPlugin.getObjectLocator();
                if (locator == null) {
                    return fields;
                }
                if (!this.isWorkingCopy) {
                    IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)this.pagedefFile);
                    if (earProject == null) {
                        return fields;
                    }
                    this.pageDefinition = locator.getPageDefinition(earProject, this.pagedefFile);
                    if (this.pageDefinition == null) {
                        return fields;
                    }
                } else if (this.pageDefinition == null) {
                    return fields;
                }
                ArrayList bindingObjects = new ArrayList();
                bindingObjects.addAll(this.pageDefinition.getBindings());
                bindingObjects.addAll(this.pageDefinition.getExecutables());
                for (IBindingObject binding : bindingObjects) {
                    IELMetadata elMetadata;
                    IStatus status = locator.validate((IObject)binding, null);
                    if (status != null && !status.isOK() || (elMetadata = binding.getELMetadata()) == null) continue;
                    this.addField(new ELPropertyProviderField(this.getProject(), binding));
                }
            }
            return super.getFields(modelContext);
        }

        protected void addSuperClassSignatures(Set<String> superClasses) {
        }

        protected void addSuperInterfaceSignatures(Set<String> superClasses) {
        }

        public boolean isNecessaryToUnload() {
            return false;
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
            this.pagedefFile = (IFile)su.readResource();
            List<DataType.Field> fields = this.getFields(null);
            if (fields != null && fields.size() > 0) {
                IObjectLocator locator = ADFPlugin.getObjectLocator();
                if (locator == null) {
                    return;
                }
                IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)this.pagedefFile);
                if (earProject == null) {
                    return;
                }
                this.pageDefinition = locator.getPageDefinition(earProject, this.pagedefFile);
                if (this.pageDefinition == null) {
                    return;
                }
                List bindingObjects = this.pageDefinition.getBindings();
                if (bindingObjects == null || bindingObjects.size() == 0) {
                    return;
                }
                for (DataType.Field field : fields) {
                    DataType dataType = field.getType();
                    if (!(dataType instanceof ELPropertyProviderDataType)) continue;
                    ELPropertyProviderDataType bindingFieldDataType = (ELPropertyProviderDataType)dataType;
                    for (IBindingObject bindingObject : bindingObjects) {
                        IELMetadata elMetadata;
                        if (!bindingObject.getId().equals(field.getName()) || (elMetadata = bindingObject.getELMetadata()) == null) continue;
                        int fieldSize = bindingFieldDataType.getNumFields(null);
                        bindingFieldDataType.describable = (IDescribable)bindingObject;
                        if (fieldSize <= 0) continue;
                        this.readBindingsFieldDataType(bindingFieldDataType);
                    }
                }
            }
        }

        private void readBindingsFieldDataType(ELPropertyProviderDataType bindingDataType) {
            IELPropertyProvider elPropertyProvider;
            List<DataType.Field> fields = bindingDataType.getFields(null);
            if (fields != null && fields.size() > 0 && (elPropertyProvider = bindingDataType.getPropertyProvider()) != null) {
                List elProperties = elPropertyProvider.getProperties();
                for (DataType.Field field : fields) {
                    DataType dataType = field.getType();
                    if (!(dataType instanceof ELPropertyProviderDataType)) continue;
                    ELPropertyProviderDataType fieldDataType = (ELPropertyProviderDataType)dataType;
                    for (IELProperty property : elProperties) {
                        if (!field.getName().equals(property.getId())) continue;
                        int fieldSize = fieldDataType.getNumFields(null);
                        fieldDataType.describable = (IDescribable)property;
                        if (fieldSize <= 0) continue;
                        this.readBindingsFieldDataType(fieldDataType);
                    }
                }
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
            su.writeResource((IResource)this.pagedefFile);
        }
    }

    private static class ELMethodInfo
    extends MethodInfo
    implements ILabeledMember {
        private IELMethod elMethod;

        public ELMethodInfo(Project project, IELMethod elMethod) {
            super(project, elMethod.getId(), elMethod.getELType().getType(), DTRTObjectUtil.getParameterTypes((IELMethod)elMethod));
            this.elMethod = elMethod;
        }

        public Object getImage() {
            return this.elMethod.getDescriptor().getImage();
        }

        public String getToolTipText() {
            return this.elMethod.getDescriptor().getToolTipText();
        }
    }

    public static final class ELPropertyProviderDataType
    extends DataType {
        private static final long serialVersionUID = 1L;
        private transient IDescribable describable;

        private ELPropertyProviderDataType(Project project, IELProperty elProperty) {
            super(null, elProperty.getELType().getType(), project);
            this.describable = elProperty;
        }

        private ELPropertyProviderDataType(Project project, IBindingObject bindingObject) {
            super(null, DTRTObjectUtil.getELMetadataType((IBindingObject)bindingObject), project);
            this.describable = bindingObject;
        }

        private IDescribable getDescribable() {
            return this.describable;
        }

        public IELPropertyProvider getPropertyProvider() {
            return this.describable instanceof IBindingObject ? ((IBindingObject)this.describable).getELMetadata() : (IELPropertyProvider)this.describable;
        }

        protected void addSuperClassSignatures(Set<String> superClasses) {
        }

        protected void addSuperInterfaceSignatures(Set<String> superClasses) {
        }

        public List<DataType.Field> getFields(IModelContext modelContext) {
            List elFields;
            IELPropertyProvider propProvider;
            List fields = super.getFields(modelContext);
            if ((fields == null || fields.size() == 0) && this.describable != null && (propProvider = this.getPropertyProvider()) != null && (elFields = propProvider.getProperties(IELField.class)) != null) {
                for (IELField elField : elFields) {
                    this.addField(new ELPropertyProviderField(this.getProject(), elField));
                }
            }
            return super.getFields(modelContext);
        }

        public List<MethodInfo> getPublicMethods() {
            List elMethods;
            IELPropertyProvider propProvider;
            ArrayList<MethodInfo> list = new ArrayList<MethodInfo>();
            if (this.describable != null && (propProvider = this.getPropertyProvider()) != null && (elMethods = propProvider.getProperties(IELMethod.class)) != null) {
                for (IELMethod elMethod : elMethods) {
                    list.add(new ELMethodInfo(this.getProject(), elMethod));
                }
            }
            return list;
        }
    }

    private static class ELPropertyProviderField
    extends DataType.Field
    implements ILabeledMember {
        public ELPropertyProviderField(Project project, IBindingObject bindingObject) {
            super(bindingObject.getId(), (DataType)new ELPropertyProviderDataType(project, bindingObject));
        }

        public ELPropertyProviderField(Project project, IELField elField) {
            super(elField.getId(), (DataType)new ELPropertyProviderDataType(project, (IELProperty)elField));
        }

        public ELPropertyProviderDataType getType() {
            return (ELPropertyProviderDataType)super.getType();
        }

        public Object getImage() {
            return this.getType().getDescribable().getDescriptor().getImage();
        }

        public String getToolTipText() {
            return this.getType().getDescribable().getDescriptor().getToolTipText();
        }
    }
}

