/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.locator.IObjectLocator;
import oracle.eclipse.tools.adf.dtrt.object.IApplication;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.internal.TraceOptions;
import oracle.eclipse.tools.adf.view.variables.BindingsVariable;
import oracle.eclipse.tools.adf.view.variables.BindingsVariableCache;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.DefaultUniqueIdGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PropertyDef;

public class ADFUtil {
    public static final String PAGE_DEF_SUFFIX = "PageDef";
    public static final String DEFAULT_DIR = "view";
    public static final String DEFAULT_PAGEDEFS_DIR = "/view/pageDefs";
    public static final String UNBOUNDED_TASK_FLOW_PAGE_PATH_PREFIX = "PageFlow#";

    public static String computeTaskFlowDescriptorString(String location, ITaskFlow taskFlow) {
        String id;
        StringBuffer sb = new StringBuffer();
        sb.append("<task-flow-descriptor path=\"");
        sb.append(location);
        sb.append("\" id=\"");
        boolean isBoundedTaskFlow = TaskFlowUtil.isBoundedTaskFlow((ITaskFlow)taskFlow);
        String string = id = isBoundedTaskFlow ? (String)taskFlow.getTaskFlowId().content() : (String)taskFlow.getId().content();
        if (id != null) {
            sb.append(id);
        }
        sb.append("\" type=\"");
        if (isBoundedTaskFlow) {
            sb.append("task-flow-definition");
            sb.append("\" uses-page-fragments=\"");
            sb.append(taskFlow.isUsePageFragments().content());
            sb.append("\" library-internal=\"false\" train=\"");
            sb.append(taskFlow.isTrain().content());
            sb.append("\"/>");
        } else {
            sb.append("\" uses-page-fragments=\"false\" library-internal=\"false\" train=\"false\"/>");
        }
        return sb.toString();
    }

    public static boolean isEmptyUnboundedTaskFlow(ITaskFlow taskFlow) {
        if (!TaskFlowUtil.isBoundedTaskFlow((ITaskFlow)taskFlow)) {
            for (PropertyDef property : ITaskFlow.TYPE.properties()) {
                ElementList list;
                ElementHandle elementHandle;
                if (!taskFlow.property(property).enabled() || !(property instanceof ElementProperty ? (elementHandle = taskFlow.property((ElementProperty)property)) != null : property instanceof ListProperty && (list = taskFlow.property((ListProperty)property)) != null && !list.isEmpty())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingsVariable getBindingsVariableForPagedef(IFile pageDefFile, IFile usingFile) {
        if (pageDefFile == null || !pageDefFile.exists()) {
            return null;
        }
        BindingsVariableCache bindingsVariableCache = BindingsVariableCache.getInstance();
        synchronized (bindingsVariableCache) {
            BindingsVariable bindingsVar = BindingsVariableCache.getInstance().getBindingsVariable(pageDefFile);
            boolean fieldsEmpty = true;
            if (bindingsVar != null) {
                DataType dataType;
                if (TraceOptions.BINDINGS_VARIABLES) {
                    TraceOptions.log("reusing binding variable in " + usingFile);
                }
                if ((dataType = bindingsVar.getType()) != null) {
                    List fields = dataType.getFields(null);
                    boolean bl = fieldsEmpty = fields == null || fields.size() == 0;
                }
            }
            if (bindingsVar == null || fieldsEmpty) {
                if (TraceOptions.BINDINGS_VARIABLES) {
                    TraceOptions.log("creating new binding variable in " + usingFile);
                }
                bindingsVar = ADFUtil.createBindingsVariable(pageDefFile.getProject(), pageDefFile, (IProgressMonitor)new NullProgressMonitor());
                if (TraceOptions.BINDINGS_VARIABLES) {
                    TraceOptions.log("done creating new binding variable in " + usingFile);
                }
            }
            return bindingsVar;
        }
    }

    public static BindingsVariable createBindingsVariable(IProject proj, IFile pageDefFile, IProgressMonitor monitor) {
        if (pageDefFile == null || !pageDefFile.exists()) {
            return null;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            Project project = (Project)proj.getAdapter(Project.class);
            progress.beginTask("Creating binding variable..", 1);
            BindingsVariable bindingsVar = new BindingsVariable(project, pageDefFile, new ResourceLocation((IResource)pageDefFile, null));
            BindingsVariableCache.getInstance().setBindingsVariable(pageDefFile, bindingsVar);
            BindingsVariable bindingsVariable = bindingsVar;
            return bindingsVariable;
        }
        finally {
            progress.done();
        }
    }

    public static IFile getPageDefFileForViewFile(IFile viewFile) {
        IPageDefinition pageDefinition = ADFUtil.getPageDefinitionForViewFile(viewFile);
        if (pageDefinition == null) {
            return null;
        }
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        return locator != null ? locator.getAccessibleFile((IObject)pageDefinition) : null;
    }

    public static Set<IFile> getTaskflowFilesForPagedef(IFile pageDefinitionFile) {
        return ADFUtil.getBoundSourceFilesForPageDef(pageDefinitionFile, IPageDefinition.IBoundSource.BoundSourceType.TASK_FLOW_ACTIVITY);
    }

    public static Set<IFile> getViewFilesForPagedef(IFile pageDefinitionFile) {
        return ADFUtil.getBoundSourceFilesForPageDef(pageDefinitionFile, IPageDefinition.IBoundSource.BoundSourceType.WEB_PAGE);
    }

    public static IFile getPagedefFileForTaskflowActivity(ITaskFlowContext.ITaskFlowProxy taskFlowProxy, String activityId) {
        if (taskFlowProxy == null) {
            return null;
        }
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return null;
        }
        IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)taskFlowProxy.getTaskFlowFile());
        if (earProject == null) {
            return null;
        }
        List activities = taskFlowProxy.getActivities();
        if (activities != null) {
            for (Object activity : activities) {
                String activityIdInProxy = taskFlowProxy.getActivityId(activity);
                if (!activityId.equals(activityIdInProxy)) continue;
                IPageDefinition pageDefinition = locator.getPageDefinitionForTaskFlowActivity(earProject, taskFlowProxy, activity);
                return pageDefinition != null ? locator.getAccessibleFile((IObject)pageDefinition) : null;
            }
        }
        return null;
    }

    public static IFile getApplicationForViewFile(IFile viewFile) {
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return null;
        }
        IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)viewFile);
        if (earProject == null) {
            return null;
        }
        IPageDefinition pageDefinition = ADFUtil.getPageDefinitionForViewFile(viewFile);
        if (pageDefinition == null) {
            return null;
        }
        Map appMap = locator.getApplications(pageDefinition);
        if (appMap != null) {
            for (IApplication application : appMap.keySet()) {
                List boundSources = (List)appMap.get(application);
                if (boundSources == null) continue;
                for (IPageDefinition.IBoundSource boundSource : boundSources) {
                    if (boundSource.getType() != IPageDefinition.IBoundSource.BoundSourceType.WEB_PAGE || !boundSource.getFile().equals((Object)viewFile)) continue;
                    return locator.getAccessibleFile((IObject)application);
                }
            }
        }
        return null;
    }

    public static Set<IFile> getApplicationFilesForPagedefFile(IFile pageDefinitionFile) {
        Map appMap;
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return Collections.EMPTY_SET;
        }
        IPageDefinition pageDefinition = ADFUtil.getPageDefinition(pageDefinitionFile);
        if (pageDefinition != null && (appMap = locator.getApplications(pageDefinition)) != null) {
            LinkedHashSet<IFile> applicationFiles = new LinkedHashSet<IFile>();
            for (IApplication app : appMap.keySet()) {
                IFile appFile = locator.getAccessibleFile((IObject)app);
                if (appFile == null) continue;
                applicationFiles.add(appFile);
            }
            return applicationFiles;
        }
        return Collections.EMPTY_SET;
    }

    public static Set<IFile> getApplicationFilesForProject(IProject project) {
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return Collections.EMPTY_SET;
        }
        IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)project);
        if (earProject == null) {
            return Collections.EMPTY_SET;
        }
        List applications = locator.getApplications(earProject, (IContainer)project);
        if (applications != null && applications.size() > 0) {
            LinkedHashSet<IFile> files = new LinkedHashSet<IFile>();
            for (IApplication application : applications) {
                IFile file = locator.getAccessibleFile((IObject)application);
                if (file == null) continue;
                files.add(file);
            }
            return files;
        }
        return Collections.EMPTY_SET;
    }

    public static PageDefIdInfoForEL getIdsFromPagedef(IFile pageDefinitionFile, String ... els) {
        List bindingObjects;
        IPageDefinition pageDefinition = ADFUtil.getPageDefinition(pageDefinitionFile);
        IObjectLocator objectLocator = ADFPlugin.getObjectLocator();
        if (pageDefinition != null && objectLocator != null && (bindingObjects = pageDefinition.findBindingObjects(els)) != null) {
            ArrayList<String> bindingIds = null;
            ArrayList<String> executableIds = null;
            ArrayList<String> taskFlowIds = null;
            for (IBindingObject bindingObject : bindingObjects) {
                IStatus status = objectLocator.validate((IObject)bindingObject, null);
                if (status != null && !status.isOK()) continue;
                String id = bindingObject.getId();
                if (bindingObject instanceof IExecutable) {
                    IDescriptor descriptor = bindingObject.getTypeDescriptor();
                    if (descriptor == null) continue;
                    if (descriptor.getLabel().equals("taskFlow")) {
                        if (taskFlowIds == null) {
                            taskFlowIds = new ArrayList<String>();
                        }
                        taskFlowIds.add(id);
                        continue;
                    }
                    if (executableIds == null) {
                        executableIds = new ArrayList<String>();
                    }
                    executableIds.add(id);
                    continue;
                }
                if (!(bindingObject instanceof IBinding)) continue;
                if (bindingIds == null) {
                    bindingIds = new ArrayList<String>();
                }
                bindingIds.add(id);
            }
            return new PageDefIdInfoForEL((List<String>)(bindingIds == null ? Collections.EMPTY_LIST : bindingIds), (List<String>)(executableIds == null ? Collections.EMPTY_LIST : executableIds), (List<String>)(taskFlowIds == null ? Collections.EMPTY_LIST : taskFlowIds));
        }
        return null;
    }

    public static List<String> getExecutableIds(IFile pageDefinitionFile, String ... els) {
        List bindingObjects;
        IPageDefinition pageDefinition = ADFUtil.getPageDefinition(pageDefinitionFile);
        if (pageDefinition != null && (bindingObjects = pageDefinition.findBindingObjects(els)) != null) {
            ArrayList<String> executableIds = new ArrayList<String>();
            for (IBindingObject bindingObject : bindingObjects) {
                if (!(bindingObject instanceof IExecutable)) continue;
                executableIds.add(bindingObject.getId());
            }
            return executableIds;
        }
        return Collections.EMPTY_LIST;
    }

    public static String generateUniqueUsageId(IFile applicationFile, IPath projectRelativePathofPage) {
        if (applicationFile == null || !applicationFile.exists()) {
            return null;
        }
        IPath path = projectRelativePathofPage.removeFirstSegments(1);
        if ((path = path.removeFileExtension()).segmentCount() == 1) {
            path = new Path(DEFAULT_DIR).append(path);
        }
        String seedId = path.toString().replace("/", "_");
        if ((seedId = seedId.replace("\\", "_")).startsWith("_")) {
            seedId = seedId.substring(1);
        }
        seedId = seedId.concat(PAGE_DEF_SUFFIX);
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return null;
        }
        IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)applicationFile);
        if (earProject == null) {
            return null;
        }
        IApplication application = locator.getApplication(earProject, applicationFile);
        if (application == null) {
            return null;
        }
        Set listOfIds = application.getPageDefinitionUsageIds();
        return ADFUtil.generateUniqueId(listOfIds, seedId);
    }

    public static String generateUniqueUsageIdFromPagedefPath(IFile applicationFile, String pageDefPath, Project project) {
        String seedId = "";
        String webContentPageDefsStr = "view.pageDefs.";
        seedId = pageDefPath.startsWith(webContentPageDefsStr) ? String.valueOf(seedId) + "view." + pageDefPath.substring(webContentPageDefsStr.length()) : String.valueOf(seedId) + pageDefPath;
        seedId = seedId.replace(".", "_");
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return null;
        }
        IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)applicationFile);
        if (earProject == null) {
            return null;
        }
        IApplication application = locator.getApplication(earProject, applicationFile);
        if (application == null) {
            return null;
        }
        Set listOfIds = application.getPageDefinitionUsageIds();
        return ADFUtil.generateUniqueId(listOfIds, seedId);
    }

    public static String getPageDefPathFromPagePath(String viewPath) {
        String path;
        Path vPath = new Path(viewPath);
        if ((vPath = vPath.removeFileExtension()).segmentCount() == 1) {
            vPath = new Path(DEFAULT_PAGEDEFS_DIR).append((IPath)vPath);
        }
        if ((path = vPath.toString()).endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.endsWith(PAGE_DEF_SUFFIX)) {
            path = path.concat(PAGE_DEF_SUFFIX);
        }
        path = path.replace("/", ".");
        path = path.replace("\\", ".");
        if ((path = path.replace("-", "_")).startsWith(".")) {
            path = path.substring(1);
        }
        return path;
    }

    public static String getPageDefLocationFromPageDefDotQualifiedPath(String pageDefnPath) {
        String pagePath = ADFUtil.getPageDefPathFromPageDefPackage(pageDefnPath);
        return "adfmsrc" + pagePath;
    }

    public static String getPageDefFileNameFromPageFileName(String pageFileName) {
        int lastIndex = pageFileName.lastIndexOf(46);
        String newNameWithoutExt = lastIndex != -1 ? pageFileName.substring(0, lastIndex) : pageFileName;
        return String.valueOf(ADFUtil.sanitizePageDefName(newNameWithoutExt)) + PAGE_DEF_SUFFIX + ".xml";
    }

    public static String getResourcePathRelativeToWebContent(IResource resource) {
        IPath path = resource.getProjectRelativePath();
        String sPath = (path = path.removeFirstSegments(1)).toString().replace("\\", "/");
        if (!sPath.startsWith("/")) {
            sPath = "/" + sPath;
        }
        return sPath;
    }

    private static String getPageDefPathFromPageDefPackage(String pageDefPath) {
        String pdPath = pageDefPath.replace(".", "/");
        pdPath = "/".concat(pdPath.concat(".xml"));
        return pdPath;
    }

    private static String sanitizePageDefName(String nameThatMayHaveHyphens) {
        return nameThatMayHaveHyphens.replace("-", "_");
    }

    private static String generateUniqueId(Collection<String> collectionOfIds, String seedId) {
        DefaultUniqueIdGenerator generator = new DefaultUniqueIdGenerator();
        return generator.generateUniqueId(collectionOfIds, seedId);
    }

    private static IPageDefinition getPageDefinitionForViewFile(IFile viewFile) {
        if (viewFile == null || !viewFile.exists()) {
            return null;
        }
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return null;
        }
        IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)viewFile);
        if (earProject == null) {
            return null;
        }
        return locator.getPageDefinitionForWebPage(earProject, viewFile);
    }

    private static Set<IFile> getBoundSourceFilesForPageDef(IFile pageDefinitionFile, IPageDefinition.IBoundSource.BoundSourceType boundSourceType) {
        if (pageDefinitionFile == null || !pageDefinitionFile.exists()) {
            return null;
        }
        IPageDefinition pageDefinition = ADFUtil.getPageDefinition(pageDefinitionFile);
        if (pageDefinition == null) {
            return Collections.emptySet();
        }
        List boundSources = pageDefinition.getBoundSources();
        if (boundSources != null) {
            Iterator itr = boundSources.iterator();
            LinkedHashSet<IFile> files = new LinkedHashSet<IFile>();
            while (itr.hasNext()) {
                IPageDefinition.IBoundSource boundSource = (IPageDefinition.IBoundSource)itr.next();
                if (boundSource.getType() != boundSourceType) continue;
                files.add(boundSource.getFile());
            }
            return files;
        }
        return Collections.emptySet();
    }

    private static IPageDefinition getPageDefinition(IFile pageDefinitionFile) {
        if (pageDefinitionFile == null || !pageDefinitionFile.exists()) {
            return null;
        }
        IObjectLocator locator = ADFPlugin.getObjectLocator();
        if (locator == null) {
            return null;
        }
        IProject earProject = DTRTUtil.getEARProject((IObjectLocator)locator, (IResource)pageDefinitionFile);
        return earProject != null ? locator.getPageDefinition(earProject, pageDefinitionFile) : null;
    }

    public static class PageDefIdInfoForEL {
        public final List<String> bindingIds;
        public final List<String> executableIds;
        public final List<String> taskFlowIds;

        public PageDefIdInfoForEL(List<String> bindingIds, List<String> executableIds, List<String> taskFlowIds) {
            this.bindingIds = bindingIds;
            this.executableIds = executableIds;
            this.taskFlowIds = taskFlowIds;
        }
    }
}

