/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.tagsupport;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.eclipse.tools.adf.view.tagsupport.ADFBindingsTypedSymbol;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedComponentSymbolDelegate;
import oracle.eclipse.tools.application.common.services.tagsupport.TypedSymbolDelegate;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.DesignTimeContextData;
import oracle.eclipse.tools.webtier.jsf.facelet.dtcontext.ELModelObjectSubExpression;
import oracle.eclipse.tools.webtier.jsf.tagsupport.IFaceletTagSymbolFactory;
import oracle.eclipse.tools.webtier.jsf.variable.FaceletDataModelVariableFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;

public class ADFFaceletSymbolFactory
implements IFaceletTagSymbolFactory {
    private static final JSFSymbolFactory ossJsfSymbolFactory = new JSFSymbolFactory();

    public ISymbol create(String symbolName, int scope, DesignTimeContextData.TagRange declaringTag, DesignTimeContextData.AttributeRange declaringAttribute, IDocument doc) {
        if ("http://xmlns.oracle.com/adf/faces/rich".equals(declaringTag.getTagIdentifier().getUri())) {
            return this.handleADFFacesTags(symbolName, declaringAttribute, declaringTag, doc);
        }
        return this.getDefaultSymbol(symbolName, declaringAttribute);
    }

    public List<String> getSupportedUris() {
        return Arrays.asList("http://xmlns.oracle.com/adf/faces/rich", "http://xmlns.oracle.com/dss/adf/faces");
    }

    private ISymbol handleADFFacesTags(String symbolName, DesignTimeContextData.AttributeRange declaringAttribute, DesignTimeContextData.TagRange declaringTag, IDocument doc) {
        ISymbol symbol = null;
        String elementName = declaringTag.getTagIdentifier().getName();
        String attrName = declaringAttribute.getName();
        if ("forEach".equals(elementName)) {
            if ("var".equals(attrName)) {
                symbol = this.handleForEachTag(symbolName, declaringAttribute, declaringTag, doc);
            }
        } else if (!"componentDef".equals(elementName)) {
            if ("pageTemplateDef".equals(elementName)) {
                symbol = this.getDefaultSymbol(symbolName, declaringAttribute);
            } else if ("var".equals(attrName)) {
                symbol = this.createSymbolFromValueAttr(symbolName, declaringAttribute, declaringTag, doc);
            } else if ("varStatus".equals(attrName)) {
                symbol = this.createSymbolForVarStatus(symbolName, declaringAttribute, declaringTag, doc);
            }
        }
        return symbol;
    }

    private ISymbol handleForEachTag(String symbolName, DesignTimeContextData.AttributeRange declaringAttribute, DesignTimeContextData.TagRange declaringTag, IDocument doc) {
        return this.createSymbol(symbolName, declaringAttribute, declaringTag, doc, "items");
    }

    private ISymbol createSymbolFromValueAttr(String symbolName, DesignTimeContextData.AttributeRange declaringAttribute, DesignTimeContextData.TagRange declaringTag, IDocument doc) {
        return this.createSymbol(symbolName, declaringAttribute, declaringTag, doc, "value");
    }

    private ISymbol createSymbol(String symbolName, DesignTimeContextData.AttributeRange declaringAttribute, DesignTimeContextData.TagRange declaringTag, IDocument doc, String valueAttrName) {
        FaceletDataModelVariableFactory dataModelVarFactory;
        DesignTimeContextData.ELRange elRange;
        DesignTimeContextData.AttributeRange attribute = declaringTag.getAttribute(valueAttrName);
        if (attribute != null && (elRange = (dataModelVarFactory = new FaceletDataModelVariableFactory()).getSingleSubexpression(attribute)) != null) {
            ELModelObjectSubExpression elModelObjectSubExpression = (ELModelObjectSubExpression)elRange.getModelSubExprs().get(0);
            String elText = elModelObjectSubExpression.toString();
            IFile file = doc.getFile();
            if (elText != null && file != null) {
                DataType dataType;
                if (elText.startsWith("bindings.") && (elText.endsWith(".collectionModel") || elText.endsWith(".treeModel")) && (dataType = this.getCollectionModelDataType(doc.getFile(), elText)) != null) {
                    ISymbol symbol = ossJsfSymbolFactory.createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, null);
                    ADFBindingsTypedSymbol typedSymbol = new ADFBindingsTypedSymbol(symbol);
                    typedSymbol.setDataType(dataType);
                    typedSymbol.setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(declaringAttribute));
                    return typedSymbol;
                }
                int offset = elRange.getStartOffset();
                ISymbol symbol = new FaceletDataModelVariableFactory().createSymbolForDataTableValue(symbolName, elModelObjectSubExpression, (IModelContext)new FilePositionContext(offset, doc.getFile()));
                symbol = new TypedSymbolDelegate(symbol);
                ((TypedSymbolDelegate)symbol).setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(declaringAttribute));
                if (symbol != null) {
                    ITypeDescriptor typeDescriptor;
                    if (symbol instanceof IObjectSymbol && (typeDescriptor = ((IObjectSymbol)symbol).getTypeDescriptor()) instanceof IMapTypeDescriptor) {
                        this.maybeAddAdditionalProps(declaringTag.getTagIdentifier().getName(), (IMapTypeDescriptor)typeDescriptor);
                    }
                    return symbol;
                }
            }
        }
        return this.getDefaultSymbol(symbolName, declaringAttribute);
    }

    private void maybeAddAdditionalProps(String tagName, IMapTypeDescriptor typeDescriptor) {
        if ("breadCrumbs".equals(tagName) || "navigationPane".equals(tagName)) {
            HashMap<String, Object> objMap = new HashMap<String, Object>(typeDescriptor.getMapSource());
            objMap.put("doAction", new Object());
            objMap.put("label", new Object());
            objMap.put("icon", new Object());
            objMap.put("destination", new Object());
            objMap.put("visible", new Object());
            objMap.put("rendered", new Object());
            typeDescriptor.setMapSource(objMap);
        }
    }

    private ISymbol createSymbolForVarStatus(String symbolName, DesignTimeContextData.AttributeRange declaringAttribute, DesignTimeContextData.TagRange declaringTag, IDocument doc) {
        String name = declaringAttribute.getName();
        if (name != null && !name.trim().isEmpty()) {
            IBoundedMapTypeDescriptor typeDescriptor = SymbolFactory.eINSTANCE.createIBoundedMapTypeDescriptor();
            if ("iterator".equals(declaringTag.getTagIdentifier().getName())) {
                HashMap<String, Object> objMap = new HashMap<String, Object>();
                objMap.put("model", new Object());
                objMap.put("rowKey", new Object());
                objMap.put("index", new Object());
                objMap.put("current", new Object());
                objMap.put("begin", new Object());
                objMap.put("first", new Object());
                objMap.put("count", new Object());
                objMap.put("step", new Object());
                typeDescriptor.setMapSource(objMap);
            }
            IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
            symbol.setName(name);
            return symbol;
        }
        return null;
    }

    private ISymbol getDefaultSymbol(String symbolName, DesignTimeContextData.AttributeRange attr) {
        IComponentSymbol cSymbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        cSymbol.setName(symbolName);
        cSymbol.setRuntimeSource(ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
        TypedComponentSymbolDelegate symbol = new TypedComponentSymbolDelegate(cSymbol);
        symbol.setDOMNode((IAdaptable)new IFaceletTagSymbolFactory.NodeAdaptable(attr));
        return symbol;
    }

    private DataType getCollectionModelDataType(IFile file, String elText) {
        List variables = VariablesController.getInstance().iterator(file, true, false, null).getVariables();
        DataType bindingDT = null;
        if (variables != null) {
            for (Variable var : variables) {
                if (!var.getName().equals("bindings")) continue;
                bindingDT = var.getType();
                break;
            }
        }
        if (bindingDT != null) {
            StringTokenizer tokenizer = new StringTokenizer(elText.substring("bindings.".length()), ".");
            DataType dt = bindingDT;
            boolean foundToken = false;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                List fields = dt.getFields(null);
                foundToken = false;
                if (fields != null) {
                    for (DataType.Field field : fields) {
                        if (!field.getName().equals(token)) continue;
                        dt = field.getType();
                        foundToken = true;
                        break;
                    }
                }
                if (!foundToken) break;
            }
            if (foundToken) {
                return dt;
            }
        }
        return null;
    }
}

