/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.taglibprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.util.INavigationCaseProvider;
import oracle.eclipse.tools.common.services.util.NavigationCaseDocumentServiceFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.ValidationMessage;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.ActionType;
import org.eclipse.osgi.util.NLS;

public class ADFActionType
extends ActionType {
    private static IPath convertToRelative(IContainer container, IResource resource) {
        return resource == null ? null : (container == null ? resource.getFullPath() : resource.getFullPath().makeRelativeTo(container.getFullPath()));
    }

    public List getPossibleValues() {
        try {
            List<IPossibleValue> possibleValues = this.getADFPossibleValues();
            if (!possibleValues.isEmpty()) {
                return possibleValues;
            }
        }
        catch (Exception exception) {}
        try {
            return super.getPossibleValues();
        }
        catch (Exception exception) {
            return new ArrayList(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidValue(String value) {
        try {
            if (value != null && value.length() > 0) {
                ArrayList<IArtifact> navigationCases = new ArrayList<IArtifact>();
                this.collectNavigationCases(navigationCases);
                for (IArtifact navigationCase : navigationCases) {
                    String caseName = navigationCase.getName();
                    if (caseName != null && !"*".equals(caseName) && !value.equals(caseName)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {}
        try {
            return super.isValidValue(value);
        }
        catch (Exception exception) {
            ValidationMessage msg = new ValidationMessage(org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages.ActionType_invalid_value);
            this.getValidationMessages().add(msg);
            return false;
        }
    }

    public List getFeatureAdapters(Class processingFeature) {
        try {
            return super.getFeatureAdapters(processingFeature);
        }
        catch (NullPointerException e) {
            ADFPlugin.log(e);
            try {
                Thread.sleep(1000L);
                return super.getFeatureAdapters(processingFeature);
            }
            catch (Exception e2) {
                ADFPlugin.log(e2);
                return new ArrayList(0);
            }
        }
    }

    private INavigationCaseProvider collectNavigationCases(Collection<IArtifact> navigationCases) {
        INavigationCaseProvider provider;
        IFile file = this.getFile2();
        if (file != null && (provider = NavigationCaseDocumentServiceFactory.getNavigationCaseProvider((IFile)file)) != null) {
            navigationCases.addAll(provider.getFromNavigationCases());
            return provider;
        }
        return null;
    }

    private List<IPossibleValue> getADFPossibleValues() {
        ArrayList<IArtifact> navigationCases = new ArrayList<IArtifact>();
        INavigationCaseProvider provider = this.collectNavigationCases(navigationCases);
        if (provider != null && !navigationCases.isEmpty()) {
            HashMap<String, ArrayList<IArtifact>> navigationCaseMap = new HashMap<String, ArrayList<IArtifact>>();
            for (IArtifact navigationCase : navigationCases) {
                ArrayList<IArtifact> list = (ArrayList<IArtifact>)navigationCaseMap.get(navigationCase.getName());
                if (list == null) {
                    list = new ArrayList<IArtifact>();
                    navigationCaseMap.put(navigationCase.getName(), list);
                }
                list.add(navigationCase);
            }
            IContainer webContentFolder = ProjectUtil.getWebContentFolderIResource((IProject)provider.getDocument().getFile().getProject());
            ArrayList<IPossibleValue> possibleValues = new ArrayList<IPossibleValue>(navigationCases.size());
            for (ArrayList<IArtifact> list : navigationCaseMap.values()) {
                possibleValues.add(this.createPossibleValue(list, provider, webContentFolder));
            }
            Collections.sort(possibleValues, PossibleValueComparator.DEFAULT);
            return possibleValues;
        }
        return Collections.emptyList();
    }

    private IPossibleValue createPossibleValue(List<IArtifact> navigationCases, INavigationCaseProvider provider, IContainer webContentFolder) {
        if (navigationCases.size() == 1) {
            IArtifact navigationCase = navigationCases.get(0);
            String[] ret = this.computeDisplayValueAndAdditionalInformation(navigationCase, provider, webContentFolder);
            PossibleValue possibleValue = new PossibleValue(navigationCase.getName(), ret[0]);
            possibleValue.setAdditionalInformation(ret[1]);
            return possibleValue;
        }
        ArrayList<String> additionalInformationList = new ArrayList<String>(navigationCases.size());
        for (IArtifact navigationCase : navigationCases) {
            additionalInformationList.add(this.computeDisplayValueAndAdditionalInformation(navigationCase, provider, webContentFolder)[1]);
        }
        Collections.sort(additionalInformationList);
        StringBuilder sb = new StringBuilder();
        for (String string : additionalInformationList) {
            sb.append("<br><br>").append(string);
        }
        PossibleValue possibleValue = new PossibleValue(navigationCases.get(0).getName());
        possibleValue.setAdditionalInformation(sb.substring("<br><br>".length()));
        return possibleValue;
    }

    private String[] computeDisplayValueAndAdditionalInformation(IArtifact navigationCase, INavigationCaseProvider provider, IContainer webContentFolder) {
        String toReferenceLabel = Messages.defaultTo;
        String toReferenceValue = null;
        IArtifact toArtifact = provider.getToArtifact(navigationCase);
        if (toArtifact != null) {
            IResource resource = provider.getToArtifactResource(navigationCase, toArtifact);
            if (resource instanceof IFile) {
                toReferenceLabel = Messages.toResource;
                toReferenceValue = ADFActionType.convertToRelative(webContentFolder, resource).toString();
            } else {
                toReferenceValue = toArtifact.getName();
            }
        }
        return new String[]{Messages.getContentAssistLabel(navigationCase, toReferenceValue), Messages.getAdditionalInformationMessage(navigationCase, webContentFolder, toReferenceLabel, toReferenceValue)};
    }

    private static final class Messages
    extends NLS {
        public static String contentAssistLabel;
        public static String additionalInformationWithoutTo;
        public static String additionalInformationWithTo;
        public static String defaultTo;
        public static String toResource;

        static {
            Messages.initializeMessages((String)ADFActionType.class.getName(), Messages.class);
        }

        private Messages() {
        }

        public static String getContentAssistLabel(IArtifact navigationCase, String toReferenceValue) {
            return toReferenceValue != null ? NLS.bind((String)contentAssistLabel, (Object)navigationCase.getName(), (Object)toReferenceValue) : navigationCase.getName();
        }

        public static String getAdditionalInformationMessage(IArtifact navigationCase, IContainer webContentFolder, String toReferenceLabel, String toReferenceValue) {
            IResource resource;
            String path = "";
            if (navigationCase.getLocation() != null && (resource = navigationCase.getLocation().getResource()) instanceof IFile) {
                path = ADFActionType.convertToRelative(webContentFolder, resource).toString();
            }
            String fromReference = navigationCase.getOwner().getName();
            return toReferenceValue == null ? NLS.bind((String)additionalInformationWithoutTo, (Object[])new String[]{path, fromReference}) : NLS.bind((String)additionalInformationWithTo, (Object[])new String[]{path, fromReference, toReferenceLabel, toReferenceValue});
        }
    }

    private static class PossibleValueComparator
    implements Comparator<IPossibleValue> {
        public static final PossibleValueComparator DEFAULT = new PossibleValueComparator();

        private PossibleValueComparator() {
        }

        @Override
        public int compare(IPossibleValue o1, IPossibleValue o2) {
            int ret = this.basicCompare(o1, o2);
            if (ret == -10) {
                if (o1.isDefaultValue() != o2.isDefaultValue()) {
                    ret = o1.isDefaultValue() ? -1 : 1;
                } else {
                    ret = this.compare(o1.getDisplayValue(), o2.getDisplayValue());
                    if (ret == 0 && (ret = this.compare(o1.getValue(), o2.getValue())) == 0) {
                        ret = this.compare(o1.getAdditionalInformation(), o2.getAdditionalInformation());
                    }
                }
            }
            return ret;
        }

        @Override
        private int compare(String s1, String s2) {
            int ret = this.basicCompare(s1, s2);
            return ret != -10 ? ret : s1.compareTo(s2);
        }

        private int basicCompare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return -10;
        }
    }
}

