/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.launch;

import java.net.URL;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerLaunchableAdapterDelegate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURL;
import org.eclipse.jst.j2ee.internal.web.jfaces.extension.FileURLExtensionReader;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public final class TaskFlowLaunchUtil {
    private TaskFlowLaunchUtil() {
    }

    public static String getDisplayName(ITaskFlow taskFlow, IPath path) {
        String displayName = TaskFlowLaunchUtil.getDisplayName(taskFlow);
        return displayName != null ? displayName : (path != null ? path.toString() : null);
    }

    private static String getDisplayName(ITaskFlow taskFlow) {
        if (taskFlow != null) {
            String displayName = (String)taskFlow.getDisplayName().content();
            if (displayName == null) {
                displayName = TaskFlowLaunchUtil.getId(taskFlow);
            }
            return displayName;
        }
        return null;
    }

    private static String getId(ITaskFlow taskFlow) {
        return taskFlow == null ? null : (TaskFlowUtil.isBoundedTaskFlow((ITaskFlow)taskFlow) ? (String)taskFlow.getTaskFlowId().content() : (String)taskFlow.getId().content());
    }

    public static String computeFacesURL(IServer server, IModule module, IContainer webContentFolder) throws CoreException {
        if (server != null && module != null) {
            WebResource auxResource;
            Object launchable;
            IPath facesPath = TaskFlowLaunchUtil.computeFacesPath(webContentFolder);
            if (facesPath == null) {
                facesPath = new Path("/");
            }
            if ((launchable = new WeblogicServerLaunchableAdapterDelegate().getLaunchable(server, (IModuleArtifact)(auxResource = new WebResource(module, facesPath)))) instanceof HttpLaunchable) {
                URL plainURL = ((HttpLaunchable)launchable).getURL();
                Path urlPath = new Path(plainURL.toString());
                return urlPath.hasTrailingSeparator() ? urlPath.toString() : String.valueOf(urlPath.toString()) + '/';
            }
        }
        return null;
    }

    public static IPath computeFacesPath(IContainer webContentFolder) {
        if (webContentFolder != null) {
            try {
                Path webResourcePath;
                String fakeFileName;
                IFile file;
                IPath facesPath;
                FileURL jspURL = FileURLExtensionReader.getInstance().getFilesURL();
                if (jspURL != null && (facesPath = jspURL.getFileURL((IResource)(file = webContentFolder.getFile((IPath)new Path(fakeFileName = "foo.jsp"))), (IPath)(webResourcePath = new Path(String.valueOf('/') + file.getName())))) != null && facesPath.segmentCount() > 1 && facesPath.toString().contains(fakeFileName)) {
                    return facesPath.removeLastSegments(1);
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

