/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.jsp.document;

import oracle.eclipse.tools.adf.view.internal.Messages;
import oracle.eclipse.tools.application.common.services.documentservices.IValueBindableComponentProvider;
import oracle.eclipse.tools.application.common.services.techextservices.IValueBindableComponent;
import oracle.eclipse.tools.application.common.services.variables.ComponentGenerationInfo;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import oracle.eclipse.tools.xml.model.emfbinding.EStoreFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.w3c.dom.Node;

public class ValueBindableComponentProviderForADF
extends AbstractDocumentService
implements IValueBindableComponentProvider {
    private Factory _factory;

    public ValueBindableComponentProviderForADF(IDocument doc) {
        super(doc);
        this._factory = new Factory((EStoreFactory<Node>)((EStoreFactory)doc.getAdapter(EStoreFactory.class)));
    }

    public IValueBindableComponent getValueBindableComponent(ComponentGenerationInfo.ComponentType type) {
        IValueBindableComponent comp = null;
        if (ComponentGenerationInfo.ComponentType.Checkbox == type) {
            return this._factory.getValueBindingComponent("selectBooleanCheckbox", "value");
        }
        if (ComponentGenerationInfo.ComponentType.CheckboxGroup == type) {
            return this._factory.getValueBindingComponent("selectManyCheckbox", "value");
        }
        if (ComponentGenerationInfo.ComponentType.Image == type) {
            return this._factory.getValueBindingComponent("image", "source");
        }
        if (ComponentGenerationInfo.ComponentType.Label == type) {
            return this._factory.getValueBindingComponent("outputText", "value");
        }
        if (ComponentGenerationInfo.ComponentType.Link == type) {
            comp = this._factory.getValueBindingComponent("goLink", "destination");
            this.setTagFeature((AbstractBaseTag)comp.getComponent(), "text", Messages.ValueBindableComponentProviderForADF_GoLink_Text);
        } else if (ComponentGenerationInfo.ComponentType.MultiLineTextbox == type) {
            comp = this._factory.getValueBindingComponent("inputText", "value");
            this.setTagFeature((AbstractBaseTag)comp.getComponent(), "rows", "3");
        } else {
            if (ComponentGenerationInfo.ComponentType.MultiSelectList == type) {
                return this._factory.getValueBindingComponent("selectManyListbox", "value");
            }
            if (ComponentGenerationInfo.ComponentType.MultiSelectMenu == type) {
                return this._factory.getValueBindingComponent("selectManyChoice", "value");
            }
            if (ComponentGenerationInfo.ComponentType.PasswordField == type) {
                comp = this._factory.getValueBindingComponent("inputText", "value");
                this.setTagFeature((AbstractBaseTag)comp.getComponent(), "secret", Boolean.TRUE);
            } else {
                if (ComponentGenerationInfo.ComponentType.RadioButtonGroup == type) {
                    return this._factory.getValueBindingComponent("selectOneRadio", "value");
                }
                if (ComponentGenerationInfo.ComponentType.SingleSelectList == type) {
                    return this._factory.getValueBindingComponent("selectOneListbox", "value");
                }
                if (ComponentGenerationInfo.ComponentType.SingleSelectMenu == type) {
                    return this._factory.getValueBindingComponent("selectOneChoice", "value");
                }
                if (ComponentGenerationInfo.ComponentType.Textbox == type) {
                    return this._factory.getValueBindingComponent("inputText", "value");
                }
            }
        }
        return comp;
    }

    private boolean setTagFeature(AbstractBaseTag tag, String featureName, Object featureValue) {
        EStructuralFeature feature = tag.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            tag.eSet(feature, featureValue);
            return true;
        }
        return false;
    }

    private class Factory {
        EStoreFactory<Node> _esFactory;

        public Factory(EStoreFactory<Node> esFactory) {
            this._esFactory = esFactory;
        }

        public IValueBindableComponent getValueBindingComponent(String compName, String attributeName) {
            EObject comp = this._esFactory.createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", compName);
            if (comp == null) {
                return null;
            }
            EStructuralFeature valueAttr = comp.eClass().getEStructuralFeature(attributeName);
            EStructuralFeature idAttr = comp.eClass().getEStructuralFeature("id");
            return new IValueBindableComponentProvider.ValueBindableComponent(comp, valueAttr, idAttr);
        }
    }
}

