/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.jsp.document;

import oracle.eclipse.tools.adf.view.internal.Messages;
import oracle.eclipse.tools.adf.view.jsp.document.ValueBindableComponentProviderForADF;
import oracle.eclipse.tools.application.common.services.documentservices.IValueBindableComponentProvider;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.IValueBindableComponent;
import oracle.eclipse.tools.application.common.services.variables.FieldGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceObservableValue;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.model.core.FacetType;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PanelFormLayoutFieldsGenerator
extends FieldsGenerator {
    private IValueBindableComponentProvider _valueBindableComponentProvider = new ValueBindableComponentProviderForADF(this.getDocument());

    public PanelFormLayoutFieldsGenerator(IDocument document) {
        this(document, Messages.PanelFormLayoutFieldGenerator_generator_name);
    }

    public PanelFormLayoutFieldsGenerator(IDocument document, String displayName) {
        super(document, displayName);
    }

    public EObject getFragment() {
        AbstractBaseTag panel = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "panelFormLayout");
        this.setTagFeature(panel, "maxColumns", "1");
        this.setTagFeature(panel, "id", "panel_" + this.getHeaderText());
        this.createHeaderIfNecessary(panel);
        for (FieldGenerationInfo field : this.getFieldsGenerationInfos()) {
            this.addField(panel, field);
        }
        this.createFooterIfNecessary(panel);
        return panel;
    }

    private void createHeaderIfNecessary(AbstractBaseTag panel) {
        if (this.doHeader()) {
            this.createFacet(panel, "header", this.getHeaderText());
        }
    }

    private void createFooterIfNecessary(AbstractBaseTag panel) {
        if (this.doFooter()) {
            this.createFacet(panel, "footer", this.getFooterText());
        }
    }

    private void createFacet(AbstractBaseTag panel, String facetName, String facetText) {
        FacetType facet = (FacetType)this.getEStoreFactory().createUnboundEObject("http://java.sun.com/jsf/core", "facet");
        facet.setName(facetName);
        AbstractBaseTag label = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "outputText");
        this.setTagFeature(label, "id", String.valueOf(facetName) + "_out");
        this.setTagFeature(label, "value", facetText);
        facet.getChildTags().add((Object)label);
        panel.getChildTags().add((Object)facet);
    }

    private String getHeaderText() {
        FieldGenerationInfo fgi = (FieldGenerationInfo)this.getFieldsGenerationInfos().get(0);
        return fgi.getValueReference().getVariable().getName();
    }

    private String getFooterText() {
        return "Footer Text";
    }

    private void addField(AbstractBaseTag panel, FieldGenerationInfo fieldGenInfo) {
        if (this.getDocumentBinderProvider() != null) {
            IValueBindableComponent bc = this.getValueBindableComponent(fieldGenInfo);
            AbstractBaseTag bindableTag = (AbstractBaseTag)bc.getComponent();
            IObservableValue target = EMFObservables.observeValue((EObject)bindableTag, (EStructuralFeature)bc.getBindableValueAttribute());
            Binding binder = this.getDocumentBinderProvider().createBinding(null, target, (IObservableValue)new ValueReferenceObservableValue(fieldGenInfo.getValueReference()));
            if (binder != null) {
                binder.updateModelToTarget();
                binder.dispose();
                String id = String.valueOf(this.getHeaderText()) + "_" + this.generateId(fieldGenInfo);
                bindableTag.eSet(bc.getIdAttribute(), (Object)id);
                if (!fieldGenInfo.getComponentGenerationInfo().isEnabled() && bindableTag.eClass().getEStructuralFeature("disabled") != null) {
                    bindableTag.eSet(bindableTag.eClass().getEStructuralFeature("disabled"), (Object)Boolean.TRUE.toString());
                }
                if (bindableTag.eClass().getEStructuralFeature("simple") != null) {
                    bindableTag.eSet(bindableTag.eClass().getEStructuralFeature("simple"), (Object)Boolean.TRUE);
                }
                AbstractBaseTag container = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "panelLabelAndMessage");
                String fieldLabel = String.valueOf(fieldGenInfo.getLabel()) + ":";
                this.setTagFeature(container, "label", fieldLabel);
                container.getChildTags().add((Object)bindableTag);
                panel.getChildTags().add((Object)container);
                if (this.doValidationMessage()) {
                    container.getChildTags().add((Object)this.getValidationMessageTag(id));
                }
            }
        }
    }

    private AbstractBaseTag getValidationMessageTag(String id) {
        AbstractBaseTag msgTag = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "message");
        this.setTagFeature(msgTag, "for", id);
        if (this.getValidationStyleClassName() != null) {
            this.setTagFeature(msgTag, "styleClass", this.getValidationStyleClassName());
        }
        return msgTag;
    }

    protected AbstractBaseTag getBindableTag() {
        return (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "outputText");
    }

    protected IValueBindableComponentProvider getValueBindableComponentProvider() {
        return this._valueBindableComponentProvider;
    }

    private boolean setTagFeature(AbstractBaseTag tag, String featureName, Object featureValue) {
        EStructuralFeature feature = tag.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            tag.eSet(feature, featureValue);
            return true;
        }
        return false;
    }
}

