/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.jsp.document;

import java.util.List;
import oracle.eclipse.tools.adf.view.jsp.document.PanelFormLayoutFieldsGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.FormsGenerator;
import oracle.eclipse.tools.application.common.services.variables.FieldGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class FormTagGenerator
extends FormsGenerator {
    private ValueReference _valRef;

    public FormTagGenerator(IDocument document) {
        super(document, "Form");
        this.setFieldsGenerator(new PanelFormLayoutFieldsGenerator(document));
    }

    public void setFieldGenerationInfos(List<FieldGenerationInfo> fieldGenInfos) {
        this._valRef = fieldGenInfos.get(0).getValueReference();
        this.getFieldsGenerator().setFieldGenerationInfos(fieldGenInfos);
    }

    public void setDoFooter(boolean doFooter) {
        this.getFieldsGenerator().setDoFooter(doFooter);
    }

    public void setDoHeader(boolean doHeader) {
        this.getFieldsGenerator().setDoHeader(doHeader);
    }

    public void setDoValidationMessage(boolean doValidationMsg) {
        this.getFieldsGenerator().setDoValidationMessage(doValidationMsg);
    }

    public void setValidationStyleClassName(String validationStyleClassName) {
        this.getFieldsGenerator().setValidationStyleClassName(validationStyleClassName);
    }

    public boolean doFooter() {
        return this.getFieldsGenerator().doFooter();
    }

    public boolean doHeader() {
        return this.getFieldsGenerator().doHeader();
    }

    public boolean doValidationMessage() {
        return this.getFieldsGenerator().doValidationMessage();
    }

    public String getValidationStyleClassName() {
        return this.getFieldsGenerator().getValidationStyleClassName();
    }

    protected AbstractBaseTag getNavigationFragment() {
        IProject project = this.getDocument().getFile().getProject();
        Project oepeProj = (Project)project.getAdapter(Project.class);
        boolean isAdf12 = oepeProj.hasTechnology("adf.web", "12.1.2");
        boolean isAdf11 = oepeProj.hasTechnology("adf.web", "11.1.1");
        AbstractBaseTag navButton = null;
        if (isAdf12) {
            navButton = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "button");
        } else if (isAdf11) {
            navButton = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "commandButton");
        }
        if (navButton != null) {
            this.setTagFeature(navButton, "action", this.getActionString());
            this.setTagFeature(navButton, "text", "Submit");
            AbstractBaseTag container = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "panelLabelAndMessage");
            this.setTagFeature(container, "label", " ");
            container.getChildTags().add((Object)navButton);
            return container;
        }
        return null;
    }

    public EObject getFragment() {
        AbstractBaseTag form = (AbstractBaseTag)this.getEStoreFactory().createUnboundEObject("http://xmlns.oracle.com/adf/faces/rich", "form");
        this.setTagFeature(form, "id", this.generateFormId());
        AbstractBaseTag panelFormLayout = (AbstractBaseTag)this.getFieldsFragment();
        if (panelFormLayout != null) {
            form.getChildTags().add((Object)panelFormLayout);
            if (this.getActionString() != null) {
                panelFormLayout.getChildTags().add((Object)this.getNavigationFragment());
            }
        }
        return form;
    }

    protected String generateFormId() {
        return String.valueOf(this._valRef.getVariable().getName()) + "Form";
    }

    private boolean setTagFeature(AbstractBaseTag tag, String featureName, Object featureValue) {
        EStructuralFeature feature = tag.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            tag.eSet(feature, featureValue);
            return true;
        }
        return false;
    }
}

