/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFControllerArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfControllerArtifact;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.services.util.StringUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class TaskflowIdRenameParticipant
extends RenameParticipant {
    private Set<IArtifactReference> referenceToRenamedArtifact = new HashSet<IArtifactReference>();
    private String oldFQNId = null;
    private String newFQNId = null;
    private String oldId = null;
    private String newId = null;

    protected boolean initialize(Object element) {
        if (element instanceof AdfControllerArtifact) {
            IArtifact artifact = (IArtifact)element;
            this.newId = this.getArguments().getNewName();
            this.oldFQNId = ((IArtifact)element).getName();
            List splitString = StringUtil.strToList((String)this.oldFQNId, (char)'#', (boolean)true);
            if (splitString.size() == 2) {
                String oldTaskFlowPath = (String)splitString.get(0);
                this.oldId = (String)splitString.get(1);
                this.newFQNId = String.valueOf(oldTaskFlowPath) + "#" + this.newId;
                ArtifactController controller = ArtifactControllerFactory.getController();
                this.referenceToRenamedArtifact.addAll(controller.getArtifactReferers(artifact));
                return this.referenceToRenamedArtifact.size() > 0;
            }
        }
        return false;
    }

    public String getName() {
        return Messages.TaskflowIdRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return RefactoringUtil.checkFileConditions(this.referenceToRenamedArtifact, (CheckConditionsContext)context);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.TaskflowIdRenameParticipant_changeName);
        HashMap fileToTextChangeMap = new HashMap();
        for (IArtifactReference reference : this.referenceToRenamedArtifact) {
            if (!(reference instanceof ADFControllerArtifactReference)) continue;
            ADFControllerArtifactReference adfCtrlRef = (ADFControllerArtifactReference)reference;
            String oldName = adfCtrlRef.isFullQualifiedReference() ? this.oldFQNId : this.oldId;
            String newName = adfCtrlRef.isFullQualifiedReference() ? this.newFQNId : this.newId;
            for (IArtifactReferenceLocation location : reference.getLocations()) {
                ResourceLocation resLocation = location.getResourceLocation();
                if (resLocation == null) continue;
                RefactoringUtil.createChangeForLocation((RefactoringProcessor)this.getProcessor(), (String)oldName, (String)newName, (ResourceLocation)resLocation, (CompositeChange)change, fileToTextChangeMap);
            }
        }
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }
}

