/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.controller.AdfControllerConfigTypeFilter;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFControllerArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFPageDefinitionArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfControllerArtifact;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.util.StringUtil;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TaskflowDeleteParticipant
extends DeleteParticipant
implements ISharableParticipant {
    private Map<IFile, List<DeleteEdit>> fileToDeleteEditsMap = null;
    private Map<IFile, Set<IFile>> taskFlowToPageDefMap = null;

    public void addElement(Object element, RefactoringArguments arguments) {
        if (!(element instanceof IFile)) {
            return;
        }
        if (!AdfControllerConfigTypeFilter.getInstance().match((IResource)((IFile)element))) {
            return;
        }
        this.determinePageDefFiles((IFile)element);
    }

    protected boolean initialize(Object element) {
        this.addElement(element, (RefactoringArguments)this.getArguments());
        if (this.taskFlowToPageDefMap == null) {
            return false;
        }
        if (element instanceof IFile) {
            Set<IFile> pageDefFiles = this.taskFlowToPageDefMap.get(element);
            return pageDefFiles != null && pageDefFiles.size() > 0;
        }
        return false;
    }

    public String getName() {
        return Messages.TaskflowDeleteParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.taskFlowToPageDefMap == null) {
            return null;
        }
        Set<IFile> taskFlowFiles = this.taskFlowToPageDefMap.keySet();
        Collection<Set<IFile>> values = this.taskFlowToPageDefMap.values();
        int i = 0;
        for (Set<IFile> files : values) {
            i += files.size();
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)i);
        sm.subTask(Messages.TaskflowDeleteParticipant_checkConditionsName);
        for (IFile taskFlowFile : taskFlowFiles) {
            Set<IFile> pageDefFiles = this.taskFlowToPageDefMap.get(taskFlowFile);
            if (pageDefFiles == null) continue;
            for (IFile pageDefFile : pageDefFiles) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    this.processPageDefFile(taskFlowFile, pageDefFile);
                }
                catch (Exception e) {
                    ADFPlugin.logError(Messages.TaskflowDeleteParticipant_errorProcessingPageDef, e);
                    return RefactoringStatus.createErrorStatus((String)Messages.TaskflowDeleteParticipant_errorProcessingPageDef);
                }
                sm.worked(1);
            }
        }
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fileToDeleteEditsMap == null) {
            return null;
        }
        Set<IFile> pageDefFiles = this.fileToDeleteEditsMap.keySet();
        if (pageDefFiles != null && pageDefFiles.size() > 0) {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)pageDefFiles.size());
            sm.subTask(Messages.TaskflowDeleteParticipant_changesSubTask);
            CompositeChange compositeChange = new CompositeChange(Messages.JSPPageDeleteRefactoringParticipant_compositeChangeText);
            for (IFile pageDefFile : pageDefFiles) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.addPageDefDeleteChangeType(pageDefFile, compositeChange);
                sm.worked(1);
            }
            return compositeChange;
        }
        return null;
    }

    protected void determinePageDefFiles(IFile taskFlowFile) {
        Object adaptedArtifact = AdapterManager.getDefault().loadAdapter((Object)taskFlowFile, IArtifact.class.getName());
        if (adaptedArtifact instanceof IArtifact) {
            Set childrenArtifacts;
            ArtifactController controller = ArtifactControllerFactory.getController();
            IArtifact artifactToDelete = (IArtifact)adaptedArtifact;
            if (artifactToDelete instanceof ResourceArtifact && artifactToDelete.getLocation().getResource() instanceof IFile && (childrenArtifacts = controller.getArtifactChildren(artifactToDelete)) != null) {
                for (IArtifact childArtifact : childrenArtifacts) {
                    Set artifactReferences;
                    if (!(childArtifact instanceof AdfControllerArtifact) || (artifactReferences = controller.getArtifactReferers(childArtifact)) == null) continue;
                    for (IArtifactReference ref : artifactReferences) {
                        Set<IFile> pageDefFiles;
                        ResourceLocation location;
                        if (!(ref instanceof ADFControllerArtifactReference) || !(ref.getOwner() instanceof ADFPageDefinitionArtifact) || (location = ref.getOwner().getLocation()) == null || !(location.getResource() instanceof IFile) || !location.getResource().exists()) continue;
                        if (this.taskFlowToPageDefMap == null) {
                            this.taskFlowToPageDefMap = new HashMap<IFile, Set<IFile>>();
                        }
                        if ((pageDefFiles = this.taskFlowToPageDefMap.get(taskFlowFile)) == null) {
                            pageDefFiles = new HashSet<IFile>();
                            this.taskFlowToPageDefMap.put(taskFlowFile, pageDefFiles);
                        }
                        pageDefFiles.add((IFile)location.getResource());
                    }
                }
            }
        }
    }

    private void addPageDefDeleteChangeType(IFile pageDefFile, CompositeChange compositeChange) {
        List<DeleteEdit> deleteEditList;
        TextChange textChange = this.getTextChange(pageDefFile);
        if (textChange == null) {
            textChange = new TextFileChange(Messages.TaskflowDeleteParticipant_textFileChangeName, pageDefFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        if ((deleteEditList = this.fileToDeleteEditsMap.get(pageDefFile)) != null) {
            for (TextEdit textEdit : deleteEditList) {
                textChange.addEdit(textEdit);
            }
        }
    }

    private void processPageDefFile(IFile taskFlowFileToDelete, IFile pageDefFile) throws CoreException, IOException {
        IStructuredModel sm = StructuredModelManager.getModelManager().getModelForRead(pageDefFile);
        IDOMModel domModel = (IDOMModel)sm;
        try {
            Element element = domModel.getDocument().getDocumentElement();
            NodeList executablesNodes = element.getElementsByTagName("executables");
            if (executablesNodes != null) {
                int i = 0;
                int len = executablesNodes.getLength();
                while (i < len) {
                    IDOMElement executableElement = (IDOMElement)executablesNodes.item(i);
                    NodeList taskFlowNodes = executableElement.getElementsByTagName("taskFlow");
                    if (taskFlowNodes != null) {
                        int j = 0;
                        int length = taskFlowNodes.getLength();
                        while (j < length) {
                            String taskFlowPath;
                            IResource res;
                            List splitString;
                            IDOMElement taskFlowElement = (IDOMElement)taskFlowNodes.item(j);
                            String taskFlowIdPath = taskFlowElement.getAttribute("taskFlowId");
                            if (taskFlowIdPath != null && taskFlowIdPath.length() > 0 && (splitString = StringUtil.strToList((String)taskFlowIdPath, (char)'#', (boolean)true)).size() == 2 && (res = this.getWebResource(taskFlowPath = (String)splitString.get(0), taskFlowFileToDelete.getProject())) != null && res.getFullPath().equals((Object)taskFlowFileToDelete.getFullPath())) {
                                if (this.fileToDeleteEditsMap == null) {
                                    this.fileToDeleteEditsMap = new HashMap<IFile, List<DeleteEdit>>();
                                }
                                if (taskFlowElement.getEndOffset() != -1 && taskFlowElement.getStartOffset() != -1) {
                                    List<DeleteEdit> deleteEditsList = this.fileToDeleteEditsMap.get(pageDefFile);
                                    if (deleteEditsList == null) {
                                        deleteEditsList = new ArrayList<DeleteEdit>();
                                        this.fileToDeleteEditsMap.put(pageDefFile, deleteEditsList);
                                    }
                                    deleteEditsList.add(new DeleteEdit(taskFlowElement.getStartOffset(), taskFlowElement.getEndOffset() - taskFlowElement.getStartOffset()));
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (sm != null) {
                sm.releaseFromRead();
            }
        }
    }

    private IResource getWebResource(String path, IProject project) {
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null && (rootFolder = vc.getRootFolder()) != null) {
            return rootFolder.getUnderlyingFolder().findMember(path);
        }
        return null;
    }
}

