/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.view.dependency.artifact.AbstractAdfActivityArtifact;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Value;

public class TaskflowActivityIDRenameParticipant
extends RenameParticipant {
    private Set<IArtifactReference> referenceToRenamedArtifact = new HashSet<IArtifactReference>();
    private String oldText = null;
    private String newText = null;
    private IFile taskFlowFile = null;
    private boolean duplicateActivityID = false;

    protected boolean initialize(Object element) {
        if (element instanceof AbstractAdfActivityArtifact) {
            IArtifact artifact = (IArtifact)element;
            IResource resource = artifact.getLocation().getResource();
            if (!(resource instanceof IFile)) {
                return false;
            }
            this.taskFlowFile = (IFile)resource;
            this.newText = this.getArguments().getNewName();
            this.oldText = ((IArtifact)element).getName();
            this.duplicateActivityID = TaskflowActivityIDRenameParticipant.checkForDuplicateActivityName(this.taskFlowFile, this.newText);
            if (this.duplicateActivityID) {
                return true;
            }
            ArtifactController controller = ArtifactControllerFactory.getController();
            this.referenceToRenamedArtifact.addAll(controller.getArtifactReferers(artifact));
            return this.referenceToRenamedArtifact.size() > 0;
        }
        return false;
    }

    public String getName() {
        return Messages.TaskflowActivityIDRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.duplicateActivityID) {
            return RefactoringStatus.createFatalErrorStatus((String)(String.valueOf(Messages.TaskflowActivityIDRenameParticipant_duplicateActivityNameStr1) + this.newText + Messages.TaskflowActivityIDRenameParticipant_duplicateActivityNameStr2));
        }
        return RefactoringUtil.checkFileConditions(this.referenceToRenamedArtifact, (CheckConditionsContext)context);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.TaskflowActivityIDRenameParticipant_compositeChangeName);
        RefactoringUtil.createChangesForArtifactReferences((RefactoringProcessor)this.getProcessor(), (CompositeChange)change, this.referenceToRenamedArtifact, (String)this.oldText, (String)this.newText, new HashMap());
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }

    private static boolean checkForDuplicateActivityName(IFile taskFlowFile, String newName) {
        ElementList activities;
        ITaskFlow taskFlow = TaskFlowFactory.createTaskFlow((IFile)taskFlowFile);
        if (taskFlow != null && (activities = taskFlow.getActivities()) != null) {
            for (IActivity activity : activities) {
                Value value = activity.getActivityId();
                if (value == null || value.text(false) == null || !value.text(false).equals(newName)) continue;
                return true;
            }
        }
        return false;
    }
}

