/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.JSPPageMoveRefactoringHelper;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.adf.view.model.ADFAppFileInfo;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPPageRenameRefactoringParticipant
extends RenameParticipant {
    private IFile jspFile;
    private String newName = null;
    private IFile pageDefFile = null;
    private IFile cpxFile = null;
    private List<ReplaceEdit> replaceEdits = null;
    private String newPageDefName = null;
    private ReplaceEdit pageDefEdit = null;

    protected boolean initialize(Object element) {
        if (element instanceof IFile && JSPUtil.isJSPContentType((IFile)((IFile)element))) {
            this.jspFile = (IFile)element;
            this.newName = this.getArguments().getNewName();
            this.pageDefFile = ADFUtil.getPageDefFileForViewFile(this.jspFile);
            return this.pageDefFile != null && this.pageDefFile.exists();
        }
        return false;
    }

    public String getName() {
        return Messages.JSPPageRenameRefactoringParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        sm.subTask(Messages.JSPPageRenameRefactoringParticipant_taskName);
        this.newPageDefName = ADFUtil.getPageDefFileNameFromPageFileName(this.newName);
        IPath newPageDefPath = this.pageDefFile.getFullPath().removeLastSegments(1).append(this.newPageDefName);
        boolean exists = ResourcesPlugin.getWorkspace().getRoot().exists(newPageDefPath);
        if (exists) {
            this.newPageDefName = JSPPageRenameRefactoringParticipant.getUniquePageDefName(this.newPageDefName, this.pageDefFile.getParent());
            newPageDefPath = this.pageDefFile.getParent().getFullPath().append(this.newPageDefName);
            exists = ResourcesPlugin.getWorkspace().getRoot().exists(newPageDefPath);
            if (exists) {
                sm.worked(2);
                return RefactoringStatus.createFatalErrorStatus((String)(String.valueOf(Messages.JSPPageRenameRefactoringParticipant_pagedefAlreadyExists1) + this.newPageDefName + Messages.JSPPageRenameRefactoringParticipant_pagedefAlreadyExists2));
            }
        }
        this.cpxFile = ADFUtil.getApplicationForViewFile(this.jspFile);
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        sm.worked(1);
        try {
            this.determineReplaceEdits();
        }
        catch (Exception e) {
            ADFPlugin.logError(Messages.JSPPageRenameRefactoringParticipant_errorDeterminingReplaceEdits, e);
            return RefactoringStatus.createFatalErrorStatus((String)Messages.JSPPageRenameRefactoringParticipant_errorDeterminingReplaceEdits);
        }
        if (this.replaceEdits != null && this.replaceEdits.size() > 0) {
            deltaFactory.change(this.cpxFile);
        }
        if (this.pageDefEdit != null) {
            deltaFactory.change(this.pageDefFile);
        }
        sm.worked(1);
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.JSPPageRenameRefactoringParticipant_compositeChangeName);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        this.addAppFileReplaceChangeType(compositeChange);
        this.addPageDefFileReplaceChangeType(compositeChange);
        sm.worked(1);
        compositeChange.add((Change)new RenameResourceChange(this.pageDefFile.getFullPath(), this.newPageDefName));
        sm.worked(1);
        return compositeChange;
    }

    private void addAppFileReplaceChangeType(CompositeChange compositeChange) {
        TextChange textChange = this.getTextChange(this.cpxFile);
        if (textChange == null) {
            textChange = new TextFileChange(Messages.JSPPageRenameRefactoringParticipant_cpxFileChangesName, this.cpxFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        if (this.replaceEdits != null) {
            for (ReplaceEdit replaceEdit : this.replaceEdits) {
                textChange.addEdit((TextEdit)replaceEdit);
            }
        }
    }

    private void addPageDefFileReplaceChangeType(CompositeChange compositeChange) {
        TextChange textChange = this.getTextChange(this.pageDefFile);
        if (textChange == null) {
            textChange = new TextFileChange(Messages.JSPPageRenameRefactoringParticipant_pagedefFileChangesName, this.pageDefFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        if (this.pageDefEdit != null) {
            textChange.addEdit((TextEdit)this.pageDefEdit);
        }
    }

    private void determineReplaceEdits() throws CoreException, IOException, ADFAppFileInfo.InvalidADFAppFileException {
        String viewPathStr = ADFUtil.getResourcePathRelativeToWebContent((IResource)this.jspFile);
        IPath pathToNewJSPFile = new Path(viewPathStr).removeLastSegments(1).append(this.newName);
        String pageDefPath = ADFUtil.getPageDefPathFromPagePath(pathToNewJSPFile.toString());
        this.replaceEdits = new ArrayList<ReplaceEdit>();
        if (this.cpxFile != null) {
            IPath newjspProjectRelativePath = this.jspFile.getProjectRelativePath().removeLastSegments(1).append(this.newName);
            String newUsageId = ADFUtil.generateUniqueUsageId(this.cpxFile, newjspProjectRelativePath);
            JSPPageMoveRefactoringHelper.determineCPXFileReplaceEdits(this.jspFile, this.replaceEdits, newUsageId, pageDefPath);
        }
        this.determinePageDefReplaceEdits();
    }

    private void determinePageDefReplaceEdits() throws IOException, CoreException {
        IStructuredModel sm = null;
        try {
            try {
                sm = StructuredModelManager.getModelManager().getModelForRead(this.pageDefFile);
                IDOMModel domModel = (IDOMModel)sm;
                IDOMElement element = (IDOMElement)domModel.getDocument().getDocumentElement();
                IDOMAttr idAttr = (IDOMAttr)element.getAttributeNode("id");
                if (idAttr != null) {
                    int index = this.newPageDefName.lastIndexOf(46);
                    this.pageDefEdit = new ReplaceEdit(idAttr.getValueRegionStartOffset() + 1, idAttr.getValue().length(), index != -1 ? this.newPageDefName.substring(0, index) : this.newPageDefName);
                }
            }
            catch (IOException ioe) {
                ADFPlugin.logError(Messages.JSPPageRenameRefactoringParticipant_errorProcessingPageDefFile, ioe);
                throw ioe;
            }
            catch (CoreException ce) {
                ADFPlugin.logError(Messages.JSPPageRenameRefactoringParticipant_errorProcessingPageDefFile, ce);
                throw ce;
            }
        }
        finally {
            sm.releaseFromRead();
        }
    }

    static String getUniquePageDefName(String pageDefName, IContainer parent) {
        int i = 0;
        boolean exists = true;
        String newPageDefName = pageDefName.endsWith(".xml") ? pageDefName.substring(0, pageDefName.length() - 4) : pageDefName;
        newPageDefName = String.valueOf(newPageDefName) + i;
        do {
            IPath newPageDefPath = parent.getFullPath().append(newPageDefName);
            exists = ResourcesPlugin.getWorkspace().getRoot().exists(newPageDefPath);
            ++i;
        } while (exists);
        return String.valueOf(newPageDefName) + ".xml";
    }
}

