/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.util.List;
import oracle.eclipse.tools.adf.view.controller.ADFModelConfigurationTypeFilter;
import oracle.eclipse.tools.adf.view.controller.ADFmApplicationConfigTypeFilter;
import oracle.eclipse.tools.adf.view.controller.ADFmDataControlConfigTypeFilter;
import oracle.eclipse.tools.adf.view.controller.ADFmPageDefinitionConfigTypeFilter;
import oracle.eclipse.tools.adf.view.controller.AdfControllerConfigTypeFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.common.internal.JSPUtil;

public abstract class FolderResourceProxyVisitor
implements IResourceProxyVisitor {
    private List<IFile> files;
    private boolean visitSubfolders = true;

    public FolderResourceProxyVisitor(List<IFile> filesList) {
        this.files = filesList;
    }

    public void setVisitSubfolders(boolean b) {
        this.visitSubfolders = b;
    }

    protected void visitFolder(IFolder folder) {
        try {
            if (!this.visitSubfolders) {
                IResource[] members = folder.members();
                if (members != null) {
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (resource.getType() == 1 && this.isValidFileType((IFile)resource)) {
                            this.files.add((IFile)resource);
                        }
                        ++n2;
                    }
                }
                return;
            }
            folder.accept((IResourceProxyVisitor)this, 0);
        }
        catch (CoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract boolean isValidFileType(IFile var1);

    public boolean visit(IResourceProxy resource) {
        switch (resource.getType()) {
            case 2: {
                return true;
            }
            case 1: {
                if (this.isValidFileType((IFile)resource.requestResource())) {
                    this.files.add((IFile)resource.requestResource());
                }
                return false;
            }
        }
        return false;
    }

    public static class AdfmFolderResourceProxyVisitor
    extends FolderResourceProxyVisitor {
        AdfmFolderResourceProxyVisitor(List<IFile> files) {
            super(files);
        }

        @Override
        protected boolean isValidFileType(IFile file) {
            return AdfControllerConfigTypeFilter.getInstance().match((IResource)file) || ADFmDataControlConfigTypeFilter.getInstance().match((IResource)file) || ADFmApplicationConfigTypeFilter.getInstance().match((IResource)file) || ADFmPageDefinitionConfigTypeFilter.getInstance().match((IResource)file) || ADFModelConfigurationTypeFilter.getInstance().match((IResource)file);
        }
    }

    public static class JSPFolderResourceProxyVisitor
    extends FolderResourceProxyVisitor {
        JSPFolderResourceProxyVisitor(List<IFile> files) {
            super(files);
        }

        @Override
        protected boolean isValidFileType(IFile file) {
            return JSPUtil.isJSPContentType((IFile)file);
        }
    }

    public static class TaskFlowFolderResourceProxyVisitor
    extends FolderResourceProxyVisitor {
        TaskFlowFolderResourceProxyVisitor(List<IFile> files) {
            super(files);
        }

        @Override
        protected boolean isValidFileType(IFile file) {
            return AdfControllerConfigTypeFilter.getInstance().match((IResource)file);
        }
    }
}

