/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.controller.ADFmPageDefinitionConfigTypeFilter;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.JSPPageDeleteRefactoringParticipant;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.DeleteEdit;

public class ADFMPageDefDeleteRefactoringParticipant
extends DeleteParticipant
implements ISharableParticipant {
    private Map<IFile, Set<IFile>> pageDefToJspsMap = null;
    private Map<IFile, List<DeleteEdit>> cpxFileToDeleteEditMap = null;
    protected List<IFile> pageDefFiles = null;

    public void addElement(Object element, RefactoringArguments arguments) {
        if (element instanceof IFile && ADFmPageDefinitionConfigTypeFilter.getInstance().match((IResource)((IFile)element))) {
            if (this.pageDefFiles == null) {
                this.pageDefFiles = new ArrayList<IFile>();
            }
            this.pageDefFiles.add((IFile)element);
        }
    }

    protected boolean initialize(Object element) {
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return this.pageDefFiles != null && this.pageDefFiles.size() > 0;
    }

    public String getName() {
        return Messages.ADFMPageDefDeleteRefactoringParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.pageDefToJspsMap == null) {
            this.pageDefToJspsMap = new HashMap<IFile, Set<IFile>>();
        }
        if (this.cpxFileToDeleteEditMap == null) {
            this.cpxFileToDeleteEditMap = new HashMap<IFile, List<DeleteEdit>>();
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)(this.pageDefFiles.size() * 2));
        sm.subTask(Messages.ADFMPageDefDeleteRefactoringParticipant_pagedefReferencesCheck);
        for (IFile pageDefFile : this.pageDefFiles) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Set<IFile> jspFiles = ADFUtil.getViewFilesForPagedef(pageDefFile);
            if (jspFiles != null) {
                this.pageDefToJspsMap.put(pageDefFile, jspFiles);
            }
            sm.worked(1);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        HashSet<IFile> viewFileDeletes = new HashSet<IFile>();
        for (IFile pageDefFile : this.pageDefToJspsMap.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Set<IFile> viewFiles = this.pageDefToJspsMap.get(pageDefFile);
            if (viewFiles != null) {
                for (IFile jspFile : viewFiles) {
                    if (viewFileDeletes.contains(jspFile)) continue;
                    viewFileDeletes.add(jspFile);
                    try {
                        JSPPageDeleteRefactoringParticipant.computeADFAppFileDeleteEdits(jspFile, this.cpxFileToDeleteEditMap);
                    }
                    catch (Exception e) {
                        ADFPlugin.logError(Messages.JSPPageDeleteRefactoringParticipant_errorComputingCPXFileEdits, e);
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.JSPPageDeleteRefactoringParticipant_errorComputingCPXFileEdits);
                    }
                }
            }
            sm.worked(1);
        }
        for (IFile cpxFile : this.cpxFileToDeleteEditMap.keySet()) {
            List<DeleteEdit> deleteEdits = this.cpxFileToDeleteEditMap.get(cpxFile);
            if (!cpxFile.exists() || deleteEdits == null || deleteEdits.size() <= 0) continue;
            deltaFactory.change(cpxFile);
        }
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.ADFMPageDefDeleteRefactoringParticipant_compositeChangeText);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)1);
        sm.subTask(Messages.ADFMPageDefDeleteRefactoringParticipant_deleteReferences);
        for (IFile cpxFile : this.cpxFileToDeleteEditMap.keySet()) {
            List<DeleteEdit> deleteEdits = this.cpxFileToDeleteEditMap.get(cpxFile);
            if (deleteEdits == null || deleteEdits.size() <= 0) continue;
            JSPPageDeleteRefactoringParticipant.addADFAppFileDeleteChangeType(cpxFile, compositeChange, (RefactoringParticipant)this, this.cpxFileToDeleteEditMap);
        }
        sm.worked(1);
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }
}

