/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifactReference;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ADFMDataControlAdapterIdRenameParticipant
extends RenameParticipant {
    private Set<IArtifactReference> referenceToRenamedArtifact = new HashSet<IArtifactReference>();
    private String oldFQNId = null;
    private String newFQNId = null;

    protected boolean initialize(Object element) {
        if (element instanceof ADFMAdapterDataControlArtifact) {
            IArtifact artifact = (IArtifact)element;
            String newId = this.getArguments().getNewName();
            this.oldFQNId = ((IArtifact)element).getName();
            int index = this.oldFQNId.lastIndexOf(46);
            String dataControlPath = index != -1 ? this.oldFQNId.substring(0, index) : this.oldFQNId;
            this.newFQNId = String.valueOf(dataControlPath) + "." + newId;
            ArtifactController controller = ArtifactControllerFactory.getController();
            this.referenceToRenamedArtifact.addAll(controller.getArtifactReferers(artifact));
            return this.referenceToRenamedArtifact.size() > 0;
        }
        return false;
    }

    public String getName() {
        return Messages.ADFMDataControlAdapterIdRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return RefactoringUtil.checkFileConditions(this.referenceToRenamedArtifact, (CheckConditionsContext)context);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.ADFMDataControlAdapterIdRenameParticipant_change);
        HashMap fileToTextChangeMap = new HashMap();
        for (IArtifactReference reference : this.referenceToRenamedArtifact) {
            if (!(reference instanceof ADFMAdapterDataControlArtifactReference)) continue;
            for (IArtifactReferenceLocation location : reference.getLocations()) {
                ResourceLocation resLocation = location.getResourceLocation();
                if (resLocation == null) continue;
                RefactoringUtil.createChangeForLocation((RefactoringProcessor)this.getProcessor(), (String)this.oldFQNId, (String)this.newFQNId, (ResourceLocation)resLocation, (CompositeChange)change, fileToTextChangeMap);
            }
        }
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }
}

