/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.view.controller.ADFmApplicationConfigTypeFilter;
import oracle.eclipse.tools.adf.view.controller.ADFmDataControlConfigTypeFilter;
import oracle.eclipse.tools.adf.view.controller.ADFmPageDefinitionConfigTypeFilter;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMApplicationArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFPageDefinitionArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfControllerArtifact;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.ADFMArtifactMoveRefactoringHelper;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ADFMArtifactReferenceRenameParticipant
extends RenameParticipant {
    private Set<IArtifactReference> referenceToRenamedArtifact = new HashSet<IArtifactReference>();
    private Set<IArtifactReference> referenceToPageDefArtifact = new HashSet<IArtifactReference>();
    private String oldText = null;
    private String newText = null;
    private String oldPageDefText = null;
    private String newPageDefText = null;
    private IFile fileToBeRenamed = null;

    protected boolean initialize(Object element) {
        Object adaptedArtifact = AdapterManager.getDefault().loadAdapter(element, IArtifact.class.getName());
        if (adaptedArtifact instanceof IArtifact) {
            Set childrenArtifacts;
            this.newText = this.getArguments().getNewName();
            IArtifact artifactToRename = (IArtifact)adaptedArtifact;
            if (element instanceof IResource) {
                this.oldText = ((IResource)element).getName();
                if (element instanceof IFile) {
                    this.fileToBeRenamed = (IFile)element;
                }
            } else {
                this.oldText = artifactToRename.getName();
            }
            ArtifactController controller = ArtifactControllerFactory.getController();
            if (artifactToRename instanceof ResourceArtifact && (childrenArtifacts = controller.getArtifactChildren(artifactToRename)) != null) {
                for (IArtifact childArtifact : childrenArtifacts) {
                    if (childArtifact instanceof AdfControllerArtifact || childArtifact instanceof ADFMDataControlArtifact || childArtifact instanceof ADFMApplicationArtifact) {
                        this.referenceToRenamedArtifact.addAll(controller.getArtifactReferers(childArtifact));
                    }
                    if (!(childArtifact instanceof ADFPageDefinitionArtifact)) continue;
                    if (this.oldPageDefText == null && this.newPageDefText == null) {
                        int index = this.oldText.indexOf(".xml");
                        int newIndex = this.newText.indexOf(".xml");
                        if (index != -1) {
                            this.oldPageDefText = this.oldText.substring(0, index);
                        }
                        if (newIndex != -1) {
                            this.newPageDefText = this.newText.substring(0, newIndex);
                        }
                    }
                    this.referenceToPageDefArtifact.addAll(controller.getArtifactReferers(childArtifact));
                }
            }
            return this.referenceToRenamedArtifact.size() > 0 || this.referenceToPageDefArtifact.size() > 0;
        }
        return false;
    }

    public String getName() {
        return Messages.ADFMArtifactReferenceRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (this.fileToBeRenamed != null && (ADFmDataControlConfigTypeFilter.getInstance().match((IResource)this.fileToBeRenamed) || ADFmApplicationConfigTypeFilter.getInstance().match((IResource)this.fileToBeRenamed))) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.ADFMArtifactReferenceRenameParticipant_cannotrenamedcxorcpx);
        }
        if (this.fileToBeRenamed != null && ADFmPageDefinitionConfigTypeFilter.getInstance().match((IResource)this.fileToBeRenamed) && this.newText != null && this.newText.indexOf(45) != -1) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.ADFMArtifactReferenceRenameParticipant_invalidPagedefFileNameCharacter);
        }
        return RefactoringUtil.checkFileConditions(this.referenceToRenamedArtifact, (CheckConditionsContext)context);
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.ADFMArtifactReferenceRenameParticipant_changeName);
        if (this.fileToBeRenamed != null) {
            ReplaceEdit replaceEdit;
            int index = this.newText.lastIndexOf(".");
            String newId = this.newText;
            if (index != -1) {
                newId = this.newText.substring(0, index);
            }
            if ((replaceEdit = ADFMArtifactMoveRefactoringHelper.determineAttrReplaceEdit(this.fileToBeRenamed, "id", newId)) != null) {
                TextChange fileChange = this.getProcessor().getRefactoring().getTextChange((Object)this.fileToBeRenamed);
                if (fileChange == null) {
                    fileChange = new TextFileChange(this.fileToBeRenamed.getName(), this.fileToBeRenamed);
                    MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
                    fileChange.setEdit((TextEdit)fileChangeRootEdit);
                    change.add((Change)fileChange);
                }
                fileChange.addEdit((TextEdit)replaceEdit);
            }
        }
        if (this.referenceToRenamedArtifact.size() > 0) {
            RefactoringUtil.createChangesForArtifactReferences((RefactoringProcessor)this.getProcessor(), (CompositeChange)change, this.referenceToRenamedArtifact, (String)this.oldText, (String)this.newText, new HashMap());
        }
        if (this.referenceToPageDefArtifact.size() > 0) {
            String parentPageDefPath;
            HashMap<IFile, TextChange> map = new HashMap<IFile, TextChange>();
            RefactoringUtil.createChangesForArtifactReferences((RefactoringProcessor)this.getProcessor(), (CompositeChange)change, this.referenceToPageDefArtifact, (String)this.oldPageDefText, (String)this.newPageDefText, map);
            if (this.fileToBeRenamed != null && (parentPageDefPath = ADFMArtifactMoveRefactoringHelper.getPackageNameForContainer(this.fileToBeRenamed.getParent())) != null) {
                for (IFile cpxFile : ADFUtil.getApplicationFilesForProject(this.fileToBeRenamed.getProject())) {
                    ADFMArtifactMoveRefactoringHelper.computePageDefIdReplaceEdits(change, this.getProcessor(), cpxFile, String.valueOf(parentPageDefPath) + "." + this.oldPageDefText, String.valueOf(parentPageDefPath) + "." + this.oldPageDefText, map);
                }
            }
        }
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }
}

