/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal.refactoring.participant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.view.ADFPlugin;
import oracle.eclipse.tools.adf.view.controller.ADFModelConfigurationTypeFilter;
import oracle.eclipse.tools.adf.view.controller.ADFmApplicationConfigTypeFilter;
import oracle.eclipse.tools.adf.view.controller.ADFmDataControlConfigTypeFilter;
import oracle.eclipse.tools.adf.view.controller.ADFmPageDefinitionConfigTypeFilter;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMAdapterDataControlArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMApplicationArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFMDataControlArtifactReference;
import oracle.eclipse.tools.adf.view.dependency.artifact.ADFPageDefinitionArtifact;
import oracle.eclipse.tools.adf.view.dependency.artifact.AdfControllerArtifact;
import oracle.eclipse.tools.adf.view.internal.refactoring.participant.Messages;
import oracle.eclipse.tools.adf.view.model.ADFAppFileInfo;
import oracle.eclipse.tools.adf.view.util.ADFUtil;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ADFMArtifactMoveRefactoringHelper {
    private final List<MoveData> referencesToMovedArtifact = new ArrayList<MoveData>();
    private Object moveDestination;

    public void setMoveDestination(Object moveDestination) {
        this.moveDestination = moveDestination;
    }

    public static String getPackageName(IFile file) {
        try {
            IDOMAttr attr = ADFMArtifactMoveRefactoringHelper.getPackageAttr(file);
            return attr != null ? attr.getValue() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getIdValue(IFile file) {
        try {
            IDOMAttr attr = ADFMArtifactMoveRefactoringHelper.getAttr(file, "id");
            return attr != null ? attr.getValue() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    void determineReferencesToADFMFiles(List<IFile> adfmFiles, IFolder folderToBeRenamedOrMoved, IContainer newContainer, boolean move) {
        for (IFile adfmFile : adfmFiles) {
            IPath relativePath = adfmFile.getFullPath().makeRelativeTo(move ? folderToBeRenamedOrMoved.getParent().getFullPath() : folderToBeRenamedOrMoved.getFullPath());
            IContainer newContainerForAdfmArtifact = newContainer;
            if (relativePath.segmentCount() > 1) {
                newContainerForAdfmArtifact = newContainer.getFolder(relativePath.removeLastSegments(1));
            }
            this.addElement(adfmFile, newContainerForAdfmArtifact);
        }
    }

    void addElement(Object element, Object destination) {
        MoveData moveData = this.createMoveData(element, destination);
        if (moveData != null) {
            this.referencesToMovedArtifact.add(moveData);
            Set<IArtifactReference> refs = moveData.references;
            if (refs != null && destination instanceof IContainer) {
                this.determineDCXAdapterIdReference(refs, (IContainer)destination);
            }
        }
    }

    boolean referencesToMovedArtifactExists() {
        return this.referencesToMovedArtifact.size() > 0;
    }

    RefactoringStatus checkConditions(RefactoringStatus status, IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        boolean cpxFileChange = false;
        if (this.referencesToMovedArtifact.size() == 0) {
            return status;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)this.referencesToMovedArtifact.size());
        subMonitor.setTaskName(Messages.ADFMArtifactMoveRefactoringHelper_checkConditionsTaskName);
        try {
            for (MoveData moveData : this.referencesToMovedArtifact) {
                status.merge(RefactoringUtil.checkFileConditions(moveData.references, (CheckConditionsContext)context));
                IResource resourceBeingMoved = moveData.artifactBeingMoved;
                if (resourceBeingMoved instanceof IFile && ADFMArtifactMoveRefactoringHelper.isPackageLevelADFMResource((IFile)resourceBeingMoved)) {
                    Set<IFile> cpxFiles;
                    ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
                    IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
                    if (moveData.destination != null) {
                        deltaFactory.change(moveData.destination.getFile((IPath)new Path(resourceBeingMoved.getName())));
                    }
                    if (!cpxFileChange && ADFMArtifactMoveRefactoringHelper.isPageDefFile(moveData.artifactBeingMoved) && (cpxFiles = ADFUtil.getApplicationFilesForPagedefFile((IFile)moveData.artifactBeingMoved)) != null) {
                        for (IFile cpxFile : cpxFiles) {
                            deltaFactory.change(cpxFile);
                            cpxFileChange = true;
                        }
                    }
                }
                subMonitor.worked(1);
            }
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
        return status;
    }

    void checkMoveFromADFMSrcFolder(RefactoringStatus status, IFile ... adfmFiles) {
        if (!(this.moveDestination instanceof IContainer)) {
            return;
        }
        if (adfmFiles != null) {
            IFile[] iFileArray = adfmFiles;
            int n = adfmFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IFile adfmFile = iFileArray[n2];
                if (ADFMArtifactMoveRefactoringHelper.isPackageLevelADFMResource(adfmFile) || ADFModelConfigurationTypeFilter.getInstance().match((IResource)adfmFile)) {
                    this.checkValidDestination(status, (IResource)adfmFile);
                }
                ++n2;
            }
        }
    }

    Change createChange(RefactoringProcessor refactoringProcessor, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.ADFMArtifactReferenceMoveParticipant_changeName);
        HashMap<IFile, TextChange> fileToTextChangeMap = new HashMap<IFile, TextChange>();
        HashSet<IResource> resourcesMoved = new HashSet<IResource>();
        for (MoveData moveData : this.referencesToMovedArtifact) {
            Set<IFile> cpxFiles;
            RefactoringUtil.createChangesForArtifactReferences((RefactoringProcessor)refactoringProcessor, (CompositeChange)change, moveData.references, (String)moveData.oldText, (String)moveData.newText, fileToTextChangeMap);
            if (!resourcesMoved.contains(moveData.artifactBeingMoved)) {
                this.determinePkgChangeEdit(change, refactoringProcessor, moveData, fileToTextChangeMap);
            }
            if (ADFMArtifactMoveRefactoringHelper.isPageDefFile(moveData.artifactBeingMoved) && (cpxFiles = ADFUtil.getApplicationFilesForPagedefFile((IFile)moveData.artifactBeingMoved)) != null) {
                for (IFile cpxFile : cpxFiles) {
                    ADFMArtifactMoveRefactoringHelper.computePageDefIdReplaceEdits(change, refactoringProcessor, cpxFile, moveData.oldText, moveData.newText, fileToTextChangeMap);
                }
            }
            if (resourcesMoved.contains(moveData.artifactBeingMoved)) continue;
            resourcesMoved.add(moveData.artifactBeingMoved);
        }
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }

    private void checkValidDestination(RefactoringStatus status, IResource resourceBeingMoved) {
        String srcFolder;
        IPath fullPath;
        if (this.moveDestination instanceof IContainer && (fullPath = ((IContainer)this.moveDestination).getFullPath()).segmentCount() > 1 && !(srcFolder = fullPath.segment(1)).equals("adfmsrc")) {
            status.addError(String.valueOf(resourceBeingMoved.getName()) + Messages.ADFMArtifactMoveRefactoringHelper_errorMovingFromADFMSrc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MoveData createMoveData(Object element, Object destination) {
        IResource resource;
        Object adaptedArtifact = AdapterManager.getDefault().loadAdapter(element, IArtifact.class.getName());
        if (!(adaptedArtifact instanceof ResourceArtifact)) return null;
        ArtifactController controller = ArtifactControllerFactory.getController();
        MoveData moveData = new MoveData();
        if (!(destination instanceof IContainer) || ((ResourceArtifact)adaptedArtifact).getLocation() == null || (resource = ((ResourceArtifact)adaptedArtifact).getLocation().getResource()) == null || !resource.exists()) return null;
        IPath oldLocationPath = RefactoringUtil.getNormailizeToContainerPath((IResource)resource);
        IPath newLocationPath = RefactoringUtil.getNormailizeToContainerPath((IResource)((IContainer)destination));
        if (oldLocationPath == null || newLocationPath == null) return null;
        if (ADFmPageDefinitionConfigTypeFilter.getInstance().match(resource)) {
            int index = resource.getName().indexOf(".xml");
            if (index == -1) {
                return null;
            }
            String resourceNameWithoutExt = resource.getName().substring(0, index);
            IContainer parentContainer = resource.getParent();
            String pkgName = ADFMArtifactMoveRefactoringHelper.getPackageNameForContainer(parentContainer);
            if (pkgName == null) {
                return null;
            }
            moveData.oldText = String.valueOf(pkgName) + "." + resourceNameWithoutExt;
            String newPkgName = ADFMArtifactMoveRefactoringHelper.getPackageNameForContainer((IContainer)destination);
            if (newPkgName == null) return null;
            moveData.newText = String.valueOf(newPkgName) + "." + resourceNameWithoutExt;
        } else {
            newLocationPath = newLocationPath.append(resource.getName());
            moveData.oldText = oldLocationPath.toString();
            moveData.newText = newLocationPath.toString();
        }
        HashSet<IArtifactReference> referenceToMovedArtifactSet = new HashSet<IArtifactReference>();
        Set childrenArtifacts = controller.getArtifactChildren((IArtifact)((ResourceArtifact)adaptedArtifact));
        if (childrenArtifacts != null) {
            for (IArtifact childArtifact : childrenArtifacts) {
                if (!(childArtifact instanceof AdfControllerArtifact) && !(childArtifact instanceof ADFMDataControlArtifact) && !(childArtifact instanceof ADFMApplicationArtifact) && !(childArtifact instanceof ADFPageDefinitionArtifact)) continue;
                referenceToMovedArtifactSet.addAll(controller.getArtifactReferers(childArtifact));
            }
        }
        moveData.artifactBeingMoved = resource;
        moveData.destination = (IContainer)destination;
        moveData.references = referenceToMovedArtifactSet;
        if (moveData.references.isEmpty()) return null;
        return moveData;
    }

    private void determinePkgChangeEdit(CompositeChange change, RefactoringProcessor refactoringProcessor, MoveData moveData, Map<IFile, TextChange> fileToChangeTextMap) throws CoreException {
        IFile fileBeingMoved;
        ReplaceEdit replaceEdit;
        if (moveData.artifactBeingMoved instanceof IFile && (replaceEdit = ADFMArtifactMoveRefactoringHelper.determinePackageNameReplaceEdit(fileBeingMoved = (IFile)moveData.artifactBeingMoved, moveData.destination)) != null) {
            TextChange fileChange = fileToChangeTextMap.get(fileBeingMoved);
            if (fileChange == null && (fileChange = refactoringProcessor.getRefactoring().getTextChange((Object)fileBeingMoved)) == null) {
                fileChange = new TextFileChange(fileBeingMoved.getName(), fileBeingMoved);
                MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
                fileChange.setEdit((TextEdit)fileChangeRootEdit);
                change.add((Change)fileChange);
                fileToChangeTextMap.put(fileBeingMoved, fileChange);
            }
            fileChange.addEdit((TextEdit)replaceEdit);
        }
    }

    private void determineDCXAdapterIdReference(Set<IArtifactReference> refs, IContainer destination) {
        String pkgName = ADFMArtifactMoveRefactoringHelper.getPackageNameForContainer(destination);
        if (pkgName == null) {
            return;
        }
        for (IArtifactReference ref : refs) {
            IArtifact owner;
            IArtifact targetArtifact;
            if (!(ref instanceof ADFMDataControlArtifactReference) || !((targetArtifact = ref.getTargetArtifact()) instanceof ADFMDataControlArtifact) || !((owner = targetArtifact.getOwner()) instanceof ResourceArtifact)) continue;
            IResource resource = ((ResourceArtifact)owner).getLocation().getResource();
            ArtifactController controller = ArtifactControllerFactory.getController();
            Set childrenArtifacts = controller.getArtifactChildren(targetArtifact);
            if (childrenArtifacts == null) continue;
            for (IArtifact childArtifact : childrenArtifacts) {
                if (!(childArtifact instanceof ADFMAdapterDataControlArtifact)) continue;
                HashSet<IArtifactReference> references = new HashSet<IArtifactReference>();
                references.addAll(controller.getArtifactReferers(childArtifact));
                for (IArtifactReference adapterIdRef : references) {
                    String refName;
                    int index;
                    if (!(adapterIdRef instanceof ADFMAdapterDataControlArtifactReference) || (index = (refName = adapterIdRef.getName()).lastIndexOf(".")) == -1 || refName.endsWith(".")) continue;
                    String adapterId = refName.substring(index);
                    MoveData moveData1 = new MoveData();
                    moveData1.oldText = refName;
                    moveData1.newText = String.valueOf(pkgName) + adapterId;
                    moveData1.references = references;
                    moveData1.artifactBeingMoved = resource;
                    moveData1.destination = destination;
                    this.referencesToMovedArtifact.add(moveData1);
                }
            }
        }
    }

    static void computePageDefIdReplaceEdits(CompositeChange change, RefactoringProcessor refactoringProcessor, IFile cpxFile, String oldText, String newText, Map<IFile, TextChange> fileToChangeTextMap) throws CoreException {
        try {
            ADFAppFileInfo appFileInfo = new ADFAppFileInfo(cpxFile, null);
            ADFAppFileInfo.MatchingPageDefNameInformation matchingPageDefInfo = appFileInfo.findMatchingPageDefNameInformation(oldText);
            if (matchingPageDefInfo != null) {
                ArrayList<ReplaceEdit> replaceEdits = new ArrayList<ReplaceEdit>();
                ADFAppFileInfo.PageDefnUsagePageInfo usageInfo = matchingPageDefInfo.getPageDefnUsagePageInfo();
                List<ADFAppFileInfo.PageMapPageInfo> listPageMapInfo = matchingPageDefInfo.getPageMapPageInfo();
                if (usageInfo != null && listPageMapInfo != null) {
                    Project project = (Project)cpxFile.getProject().getAdapter(Project.class);
                    String newusageId = ADFUtil.generateUniqueUsageIdFromPagedefPath(cpxFile, newText, project);
                    ADFAppFileInfo.AttrInfo idAttrInfo = usageInfo.getIdAttrInfo();
                    if (idAttrInfo != null) {
                        String id = idAttrInfo.getAttrValue();
                        replaceEdits.add(new ReplaceEdit(idAttrInfo.getValueStartOffset(), id.length(), newusageId));
                    }
                    for (ADFAppFileInfo.PageMapPageInfo pageMapInfo : listPageMapInfo) {
                        ADFAppFileInfo.AttrInfo usageIdAttrInfo = pageMapInfo.getUsageIdAttrInfo();
                        if (usageIdAttrInfo == null) continue;
                        String usageId = usageIdAttrInfo.getAttrValue();
                        replaceEdits.add(new ReplaceEdit(usageIdAttrInfo.getValueStartOffset(), usageId.length(), newusageId));
                    }
                }
                if (replaceEdits.size() > 0) {
                    TextChange fileChange = fileToChangeTextMap.get(cpxFile);
                    if (fileChange == null && (fileChange = refactoringProcessor.getRefactoring().getTextChange((Object)cpxFile)) == null) {
                        fileChange = new TextFileChange(cpxFile.getName(), cpxFile);
                        MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
                        fileChange.setEdit((TextEdit)fileChangeRootEdit);
                        change.add((Change)fileChange);
                        fileToChangeTextMap.put(cpxFile, fileChange);
                    }
                    for (ReplaceEdit replaceEdit : replaceEdits) {
                        fileChange.addEdit((TextEdit)replaceEdit);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.adf.view", Messages.ADFMArtifactMoveRefactoringHelper_errorComputingPageDefId, (Throwable)e));
        }
    }

    static String getPackageNameForContainer(IContainer container) {
        IPath path = container.getProjectRelativePath();
        IProject project = container.getProject();
        IFolder folder = project.getFolder(path.segment(0));
        IJavaElement javaElem = JavaCore.create((IFolder)folder);
        if (!(javaElem instanceof IPackageFragmentRoot)) {
            return null;
        }
        path = path.removeFirstSegments(1);
        return path.toString().replace('/', '.');
    }

    static ReplaceEdit determineAttrReplaceEdit(IFile file, String attrName, String attrValue) throws CoreException {
        if (ADFMArtifactMoveRefactoringHelper.isPackageLevelADFMResource(file)) {
            try {
                IDOMAttr attr = ADFMArtifactMoveRefactoringHelper.getAttr(file, attrName);
                if (attr != null) {
                    return new ReplaceEdit(attr.getValueRegionStartOffset() + 1, attr.getValue().length(), attrValue);
                }
            }
            catch (CoreException ce) {
                ADFPlugin.logError(Messages.ADFMArtifactMoveRefactoringHelper_error_reading_file, ce);
                throw ce;
            }
            catch (IOException ioe) {
                ADFPlugin.logError(Messages.ADFMArtifactMoveRefactoringHelper_error_reading_file, ioe);
                return null;
            }
        }
        return null;
    }

    private static boolean isPageDefFile(IResource resource) {
        return ADFmPageDefinitionConfigTypeFilter.getInstance().match(resource);
    }

    private static boolean isPackageLevelADFMResource(IFile file) {
        return ADFmDataControlConfigTypeFilter.getInstance().match((IResource)file) || ADFmApplicationConfigTypeFilter.getInstance().match((IResource)file) || ADFmPageDefinitionConfigTypeFilter.getInstance().match((IResource)file);
    }

    private static ReplaceEdit determinePackageNameReplaceEdit(IFile file, IContainer destination) throws CoreException {
        String pkgName = ADFMArtifactMoveRefactoringHelper.getPackageNameForContainer(destination);
        return pkgName != null ? ADFMArtifactMoveRefactoringHelper.determineAttrReplaceEdit(file, "Package", pkgName) : null;
    }

    private static IDOMAttr getPackageAttr(IFile file) throws CoreException, IOException {
        return ADFMArtifactMoveRefactoringHelper.getAttr(file, "Package");
    }

    private static IDOMAttr getAttr(IFile file, String attrName) throws CoreException, IOException {
        IStructuredModel sm = null;
        try {
            IDOMAttr pkgAttr;
            sm = StructuredModelManager.getModelManager().getModelForRead(file);
            IDOMModel domModel = (IDOMModel)sm;
            IDOMElement element = (IDOMElement)domModel.getDocument().getDocumentElement();
            IDOMAttr iDOMAttr = pkgAttr = (IDOMAttr)element.getAttributeNode(attrName);
            return iDOMAttr;
        }
        finally {
            sm.releaseFromRead();
        }
    }

    private static final class MoveData {
        private String oldText = null;
        private String newText = null;
        private IResource artifactBeingMoved = null;
        private IContainer destination = null;
        Set<IArtifactReference> references = null;

        private MoveData() {
        }
    }
}

