/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.view.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.adf.view.internal.Messages;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IServerModuleHelper;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainInfo;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainTemplateUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class ServerModuleHelper
implements IServerModuleHelper {
    private static final String ADF_DOMAIN_EXT_ID = "Oracle JRF";

    public IModule[] getRootModules(IModule module) {
        return null;
    }

    public IStatus canSupportModule(IServer server, File domainPath, IModule module) {
        if (ServerModuleHelper.hasAdfFacets(module)) {
            if (server.getServerState() == 2) {
                if (!ServerModuleHelper.isAdfDomainExtensionInstalled(server)) {
                    return new Status(4, "oracle.eclipse.tools.adf.view", Messages.ErrorADFWebProjectRequiresADFDomainExtension);
                }
                return Status.OK_STATUS;
            }
            if (domainPath == null) {
                return Status.OK_STATUS;
            }
            WeblogicServer weblogic = (WeblogicServer)server.getAdapter(WeblogicServer.class);
            DomainInfo domainInfo = null;
            try {
                domainInfo = DomainTemplateUtil.parseDomainInfo((WeblogicServer)weblogic);
                boolean hasAdfDomainExtension = false;
                if (domainInfo != null) {
                    for (TemplateInfo tempInfo : domainInfo.extensionTemplates) {
                        if (!tempInfo.getFullName().startsWith(ADF_DOMAIN_EXT_ID)) continue;
                        hasAdfDomainExtension = true;
                        break;
                    }
                    if (!hasAdfDomainExtension) {
                        return new Status(4, "oracle.eclipse.tools.adf.view", Messages.ErrorADFWebProjectRequiresADFDomainExtension);
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAdfFacets(IModule module) {
        if (module == null) return false;
        try {
            IProjectFacetVersion fv;
            IProject project = module.getProject();
            if (project == null) return false;
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj == null) return false;
            Set projectFacets = fproj.getProjectFacets();
            if (projectFacets == null) return false;
            Iterator itr = projectFacets.iterator();
            do {
                if (!itr.hasNext()) {
                    return false;
                }
                fv = (IProjectFacetVersion)itr.next();
                if ("oracle.adf.web".equals(fv.getProjectFacet().getId())) return true;
            } while (!"oracle.adf.ear".equals(fv.getProjectFacet().getId()));
            return true;
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean isAdfDomainExtensionInstalled(IServer server) {
        WeblogicServerBehaviour behaviour = (WeblogicServerBehaviour)server.loadAdapter(WeblogicServerBehaviour.class, null);
        IJ2EEDeploymentHelper deployHelper = behaviour.getPublisher();
        IWlsJMXHelper jmxHelper = deployHelper.getWlsJMXHelper();
        HashMap libModules = jmxHelper.getLibraries();
        for (String s : libModules.keySet()) {
            if (!s.startsWith("adf.oracle.domain#")) continue;
            return true;
        }
        return false;
    }
}

